/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.transcoder.image;

import java.util.HashMap;
import java.util.Map;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscodingHints;
import org.apache.batik.transcoder.image.AbstractImageTranscoderTest;
import org.apache.batik.transcoder.image.ImageTranscoder;

public class DimensionTest
extends AbstractImageTranscoderTest {
    protected String inputURI;
    protected String refImageURI;
    protected Float width;
    protected Float height;

    public DimensionTest(String inputURI, String refImageURI, Float width, Float height) {
        this.inputURI = inputURI;
        this.refImageURI = refImageURI;
        this.width = width;
        this.height = height;
    }

    @Override
    protected TranscoderInput createTranscoderInput() {
        return new TranscoderInput(this.resolveURL(this.inputURI).toString());
    }

    @Override
    protected Map createTranscodingHints() {
        HashMap<TranscodingHints.Key, Float> hints = new HashMap<TranscodingHints.Key, Float>(7);
        if (this.width.floatValue() > 0.0f) {
            hints.put(ImageTranscoder.KEY_WIDTH, this.width);
        }
        if (this.height.floatValue() > 0.0f) {
            hints.put(ImageTranscoder.KEY_HEIGHT, this.height);
        }
        return hints;
    }

    @Override
    protected byte[] getReferenceImageData() {
        return DimensionTest.createBufferedImageData(this.resolveURL(this.refImageURI));
    }
}

