/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.transcoder.image;

import java.io.IOException;
import java.net.URL;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.dom.util.SAXDocumentFactory;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.image.AbstractImageTranscoderTest;
import org.apache.batik.util.XMLResourceDescriptor;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;

public class GenericDocumentTest
extends AbstractImageTranscoderTest {
    protected String inputURI;
    protected String refImageURI;

    public GenericDocumentTest(String inputURI, String refImageURI) {
        this.inputURI = inputURI;
        this.refImageURI = refImageURI;
    }

    @Override
    protected TranscoderInput createTranscoderInput() {
        try {
            URL url = this.resolveURL(this.inputURI);
            String parser = XMLResourceDescriptor.getXMLParserClassName();
            DOMImplementation impl = GenericDOMImplementation.getDOMImplementation();
            SAXDocumentFactory f = new SAXDocumentFactory(impl, parser);
            Document doc = f.createDocument(url.toString());
            TranscoderInput input = new TranscoderInput(doc);
            input.setURI(url.toString());
            return input;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw new IllegalArgumentException(this.inputURI);
        }
    }

    @Override
    protected byte[] getReferenceImageData() {
        return GenericDocumentTest.createBufferedImageData(this.resolveURL(this.refImageURI));
    }
}

