/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.transcoder.image;

import java.util.HashMap;
import java.util.Map;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscodingHints;
import org.apache.batik.transcoder.image.AbstractImageTranscoderTest;
import org.apache.batik.transcoder.image.ImageTranscoder;

public class MaxDimensionTest
extends AbstractImageTranscoderTest {
    protected String inputURI;
    protected String refImageURI;
    protected Float maxWidth = new Float(Float.NaN);
    protected Float maxHeight = new Float(Float.NaN);
    protected Float width = new Float(Float.NaN);
    protected Float height = new Float(Float.NaN);

    public MaxDimensionTest(String inputURI, String refImageURI, Float maxWidth, Float maxHeight) {
        this.inputURI = inputURI;
        this.refImageURI = refImageURI;
        this.maxWidth = maxWidth;
        this.maxHeight = maxHeight;
    }

    public MaxDimensionTest(String inputURI, String refImageURI, Float maxWidth, Float maxHeight, Float width, Float height) {
        this.inputURI = inputURI;
        this.refImageURI = refImageURI;
        this.maxWidth = maxWidth;
        this.maxHeight = maxHeight;
        this.width = width;
        this.height = height;
    }

    @Override
    protected TranscoderInput createTranscoderInput() {
        return new TranscoderInput(this.resolveURL(this.inputURI).toString());
    }

    @Override
    protected Map createTranscodingHints() {
        HashMap<TranscodingHints.Key, Float> hints = new HashMap<TranscodingHints.Key, Float>(7);
        if (!this.width.isNaN() && this.width.floatValue() > 0.0f) {
            hints.put(ImageTranscoder.KEY_WIDTH, this.width);
        }
        if (!this.height.isNaN() && this.height.floatValue() > 0.0f) {
            hints.put(ImageTranscoder.KEY_HEIGHT, this.height);
        }
        if (this.maxWidth.floatValue() > 0.0f) {
            hints.put(ImageTranscoder.KEY_MAX_WIDTH, this.maxWidth);
        }
        if (this.maxHeight.floatValue() > 0.0f) {
            hints.put(ImageTranscoder.KEY_MAX_HEIGHT, this.maxHeight);
        }
        return hints;
    }

    @Override
    protected byte[] getReferenceImageData() {
        return MaxDimensionTest.createBufferedImageData(this.resolveURL(this.refImageURI));
    }
}

