/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.transcoder.image;

import java.util.HashMap;
import java.util.Map;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscodingHints;
import org.apache.batik.transcoder.image.AbstractImageTranscoderTest;
import org.apache.batik.transcoder.image.ImageTranscoder;

public class PixelToMMTest
extends AbstractImageTranscoderTest {
    protected String inputURI;
    protected String refImageURI;
    protected Float px2mm;

    public PixelToMMTest(String inputURI, String refImageURI, Float px2mm) {
        this.inputURI = inputURI;
        this.refImageURI = refImageURI;
        this.px2mm = px2mm;
    }

    @Override
    protected TranscoderInput createTranscoderInput() {
        return new TranscoderInput(this.resolveURL(this.inputURI).toString());
    }

    @Override
    protected Map createTranscodingHints() {
        HashMap<TranscodingHints.Key, Float> hints = new HashMap<TranscodingHints.Key, Float>(3);
        hints.put(ImageTranscoder.KEY_PIXEL_UNIT_TO_MILLIMETER, this.px2mm);
        return hints;
    }

    @Override
    protected byte[] getReferenceImageData() {
        return PixelToMMTest.createBufferedImageData(this.resolveURL(this.refImageURI));
    }
}

