/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.transcoder.wmf;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.batik.test.AbstractTest;
import org.apache.batik.test.DefaultTestReport;
import org.apache.batik.test.TestReport;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.wmf.Messages;
import org.apache.batik.transcoder.wmf.tosvg.WMFTranscoder;
import org.apache.batik.util.SVGConstants;

public class WMFAccuracyTest
extends AbstractTest
implements SVGConstants {
    public static final String GENERATOR_REFERENCE_BASE = "test-references/org/apache/batik/transcoder/wmf";
    public static final String CANDIDATE_REF_DIR = "candidate";
    public static final String WMF_EXTENSION = ".wmf";
    public static final String SVG_EXTENSION = ".svg";
    public static final char PATH_SEPARATOR = '/';
    public static final String ERROR_CANNOT_GENERATE_SVG = "WMFAccuracyTest.error.cannot.generate.svg";
    public static final String ERROR_CANNOT_OPEN_REFERENCE_SVG_FILE = "WMFAccuracyTest.error.cannot.open.reference.svg.file";
    public static final String ERROR_ERROR_WHILE_COMPARING_FILES = "WMFAccuracyTest.error.while.comparing.files";
    public static final String ERROR_GENERATED_SVG_INACCURATE = "WMFAccuracyTest.error.generated.svg.inaccurate";
    public static final String ENTRY_KEY_ERROR_DESCRIPTION = "WMFAccuracyTest.entry.key.error.description";
    public static final String ENTRY_KEY_LINE_NUMBER = "WMFAccuracyTest.entry.key.line.number";
    public static final String ENTRY_KEY_COLUMN_NUMBER = "WMFAccuracyTest.entry.key.column.number";
    public static final String ENTRY_KEY_COLUMN_EXPECTED_VALUE = "WMFAccuracyTest.entry.key.column.expected.value";
    public static final String ENTRY_KEY_COLUMN_FOUND_VALUE = "WMFAccuracyTest.entry.key.column.found.value";
    public static final String ENTRY_KEY_REFERENCE_LINE = "WMFAccuracyTest.entry.key.reference.line";
    public static final String ENTRY_KEY_NEW_LINE = "WMFAccuracyTest.entry.key.new.line";
    public static final String REF_IMAGE_PREFIX = "test-references/";
    private URL wmfURL;
    private URL refURL;
    private File saveSVG;

    protected String[] breakWMFFile(String wmfFile) {
        if (wmfFile == null) {
            throw new IllegalArgumentException("Null WMF file given");
        }
        String[] ret = new String[3];
        if (!wmfFile.endsWith(WMF_EXTENSION)) {
            throw new IllegalArgumentException("WMF File must end in '.wmf': " + wmfFile);
        }
        ret[2] = WMF_EXTENSION;
        wmfFile = wmfFile.substring(0, wmfFile.length() - ret[2].length());
        int fileNameStart = wmfFile.lastIndexOf(47);
        String wmfDir = "";
        if (fileNameStart != -1) {
            if (wmfFile.length() < fileNameStart + 2) {
                throw new IllegalArgumentException("Nothing after '/': " + wmfFile);
            }
            wmfDir = wmfFile.substring(0, fileNameStart + 1);
            wmfFile = wmfFile.substring(fileNameStart + 1);
        }
        ret[0] = wmfDir;
        ret[1] = wmfFile;
        return ret;
    }

    @Override
    public void setId(String id) {
        super.setId(id);
        this.setFile(id);
    }

    public void setFile(String id) {
        String wmfFile = id;
        String[] dirNfile = this.breakWMFFile(wmfFile);
        this.wmfURL = this.resolveURL(String.valueOf(dirNfile[0]) + dirNfile[1] + dirNfile[2]);
        this.refURL = this.resolveURL("test-references/org/apache/batik/transcoder/wmf/" + dirNfile[1] + SVG_EXTENSION);
        this.saveSVG = new File("test-references/org/apache/batik/transcoder/wmf/candidate/" + dirNfile[1] + SVG_EXTENSION);
    }

    protected URL resolveURL(String url) {
        File f = new File(url).getAbsoluteFile();
        if (f.getParentFile().exists()) {
            try {
                return f.toURL();
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException();
            }
        }
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(url);
        }
    }

    public File getSaveSVG() {
        return this.saveSVG;
    }

    public void setSaveSVG(File saveSVG) {
        this.saveSVG = saveSVG;
    }

    @Override
    public TestReport runImpl() throws Exception {
        BufferedReader refReader;
        DefaultTestReport report = new DefaultTestReport(this);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            WMFTranscoder wmft = new WMFTranscoder();
            TranscoderInput input = new TranscoderInput(this.wmfURL.toString());
            OutputStreamWriter outW = new OutputStreamWriter((OutputStream)out, "UTF-8");
            TranscoderOutput output = new TranscoderOutput(outW);
            wmft.transcode(input, output);
        }
        catch (Exception e) {
            StringWriter trace = new StringWriter();
            e.printStackTrace(new PrintWriter(trace));
            report.setErrorCode(ERROR_CANNOT_GENERATE_SVG);
            String desc = Messages.formatMessage(ENTRY_KEY_ERROR_DESCRIPTION, null);
            String msg = Messages.formatMessage(ERROR_CANNOT_GENERATE_SVG, new String[]{this.wmfURL.toString(), e.getClass().getName(), e.getMessage(), trace.toString()});
            report.setDescription(new TestReport.Entry[]{new TestReport.Entry(desc, msg)});
            report.setPassed(false);
            return report;
        }
        try {
            InputStream is = this.refURL.openStream();
            InputStreamReader r = new InputStreamReader(is);
            refReader = new BufferedReader(r);
        }
        catch (Exception e) {
            report.setErrorCode(ERROR_CANNOT_OPEN_REFERENCE_SVG_FILE);
            String refURLStr = this.refURL != null ? this.refURL.toExternalForm() : "null";
            String desc = Messages.formatMessage(ENTRY_KEY_ERROR_DESCRIPTION, null);
            String msg = Messages.formatMessage(ERROR_CANNOT_OPEN_REFERENCE_SVG_FILE, new Object[]{refURLStr, e.getMessage()});
            report.setDescription(new TestReport.Entry[]{new TestReport.Entry(desc, msg)});
            report.setPassed(false);
            this.save(out.toByteArray());
            return report;
        }
        byte[] data = out.toByteArray();
        ByteArrayInputStream gen = new ByteArrayInputStream(data);
        InputStreamReader r = new InputStreamReader(gen);
        BufferedReader genReader = new BufferedReader(r);
        try {
            String refStr = refReader.readLine();
            String genStr = genReader.readLine();
            int line = 1;
            while (refStr != null && genStr != null) {
                if (!refStr.equals(genStr)) break;
                refStr = refReader.readLine();
                genStr = genReader.readLine();
                ++line;
            }
            if (refStr == null && genStr == null) {
                report.setPassed(true);
                return report;
            }
            this.save(out.toByteArray());
            int cn = this.computeColumnNumber(refStr, genStr);
            String expectedChar = "<eol>";
            if (cn >= 0 && refStr != null && refStr.length() > cn) {
                expectedChar = refStr.substring(cn, cn + 1);
            }
            String foundChar = "<null>";
            if (cn >= 0 && genStr != null && genStr.length() > cn) {
                foundChar = genStr.substring(cn, cn + 1);
            }
            if (expectedChar.equals(" ")) {
                expectedChar = "' '";
            }
            if (foundChar.equals(" ")) {
                foundChar = "' '";
            }
            report.setErrorCode(ERROR_GENERATED_SVG_INACCURATE);
            report.addDescriptionEntry(this.fmtMsg(ENTRY_KEY_LINE_NUMBER), new Integer(line));
            report.addDescriptionEntry(this.fmtMsg(ENTRY_KEY_COLUMN_NUMBER), new Integer(cn));
            report.addDescriptionEntry(this.fmtMsg(ENTRY_KEY_COLUMN_EXPECTED_VALUE), expectedChar);
            report.addDescriptionEntry(this.fmtMsg(ENTRY_KEY_COLUMN_FOUND_VALUE), foundChar);
            report.addDescriptionEntry(this.fmtMsg(ENTRY_KEY_REFERENCE_LINE), refStr);
            report.addDescriptionEntry(this.fmtMsg(ENTRY_KEY_NEW_LINE), genStr);
            report.setPassed(false);
        }
        catch (Exception e) {
            String desc = Messages.formatMessage(ENTRY_KEY_ERROR_DESCRIPTION, null);
            String msg = Messages.formatMessage(ERROR_ERROR_WHILE_COMPARING_FILES, new Object[]{this.refURL.toExternalForm(), e.getMessage()});
            report.setErrorCode(ERROR_ERROR_WHILE_COMPARING_FILES);
            report.setDescription(new TestReport.Entry[]{new TestReport.Entry(desc, msg)});
            report.setPassed(false);
            this.save(out.toByteArray());
            return report;
        }
        return report;
    }

    protected void save(byte[] data) throws IOException {
        if (this.saveSVG == null) {
            return;
        }
        FileOutputStream os = new FileOutputStream(this.saveSVG);
        os.write(data);
        os.close();
    }

    public int computeColumnNumber(String aStr, String bStr) {
        if (aStr == null || bStr == null) {
            return -1;
        }
        int n = aStr.length();
        int i = -1;
        i = 0;
        while (i < n) {
            char b;
            char a = aStr.charAt(i);
            if (i >= bStr.length() || a != (b = bStr.charAt(i))) break;
            ++i;
        }
        return i;
    }

    protected String fmtMsg(String str) {
        return Messages.formatMessage(str, null);
    }
}

