/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.util;

import org.apache.batik.apps.svgbrowser.Main;
import org.apache.batik.test.AbstractTest;
import org.apache.batik.test.DefaultTestSuite;
import org.apache.batik.util.ApplicationSecurityEnforcer;

public class ApplicationSecurityEnforcerTest
extends DefaultTestSuite {
    static final Class APP_MAIN_CLASS = Main.class;
    static final String APP_SECURITY_POLICY = "org/apache/batik/apps/svgbrowser/resources/svgbrowser.policy";

    public ApplicationSecurityEnforcerTest() {
        this.addTest(new CheckNoSecurityManagerOverride());
        this.addTest(new CheckSecurityEnforcement());
        this.addTest(new CheckSecurityRemoval());
        this.addTest(new CheckNoPolicyFile());
    }

    static ApplicationSecurityEnforcer buildTestTarget() {
        return new ApplicationSecurityEnforcer(APP_MAIN_CLASS, APP_SECURITY_POLICY);
    }

    static class CheckNoPolicyFile
    extends AbstractTest {
        CheckNoPolicyFile() {
        }

        @Override
        public boolean runImplBasic() {
            ApplicationSecurityEnforcer ase = new ApplicationSecurityEnforcer(APP_MAIN_CLASS, "dont.exist.policy");
            try {
                try {
                    ase.enforceSecurity(true);
                }
                catch (NullPointerException se) {
                    ase.enforceSecurity(false);
                    return true;
                }
            }
            finally {
                ase.enforceSecurity(false);
            }
            return false;
        }
    }

    static class CheckNoSecurityManagerOverride
    extends AbstractTest {
        CheckNoSecurityManagerOverride() {
        }

        @Override
        public boolean runImplBasic() {
            ApplicationSecurityEnforcer aseA = ApplicationSecurityEnforcerTest.buildTestTarget();
            aseA.enforceSecurity(true);
            ApplicationSecurityEnforcer aseB = ApplicationSecurityEnforcerTest.buildTestTarget();
            boolean passed = false;
            try {
                aseB.enforceSecurity(true);
            }
            catch (SecurityException se) {
                System.out.println(">>>>>>>>>>>>> got expected SecurityException A");
                try {
                    System.out.println(">>>>>>>>>>>>> got expected SecurityException B");
                    aseB.enforceSecurity(false);
                }
                catch (SecurityException se2) {
                    passed = true;
                }
            }
            aseA.enforceSecurity(false);
            return passed;
        }
    }

    static class CheckSecurityEnforcement
    extends AbstractTest {
        CheckSecurityEnforcement() {
        }

        @Override
        public boolean runImplBasic() {
            ApplicationSecurityEnforcer ase = ApplicationSecurityEnforcerTest.buildTestTarget();
            try {
                ase.enforceSecurity(true);
                SecurityManager sm = System.getSecurityManager();
                if (sm == ase.lastSecurityManagerInstalled) {
                    return true;
                }
            }
            finally {
                System.setSecurityManager(null);
            }
            return false;
        }
    }

    static class CheckSecurityRemoval
    extends AbstractTest {
        CheckSecurityRemoval() {
        }

        @Override
        public boolean runImplBasic() {
            ApplicationSecurityEnforcer ase = ApplicationSecurityEnforcerTest.buildTestTarget();
            try {
                ase.enforceSecurity(true);
                ase.enforceSecurity(false);
                SecurityManager sm = System.getSecurityManager();
                if (sm == null && ase.lastSecurityManagerInstalled == null) {
                    return true;
                }
            }
            finally {
                System.setSecurityManager(null);
            }
            return false;
        }
    }
}

