/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.util;

import java.util.ArrayList;
import java.util.Random;
import org.apache.batik.test.AbstractTest;
import org.apache.batik.test.TestReport;
import org.apache.batik.util.RunnableQueue;
import org.apache.batik.util.ThreadPounder;

public class RunnableQueueTest
extends AbstractTest {
    public int nThreads;
    public int activeThreads;
    public Random rand;
    public RunnableQueue rq;
    public static final int INVOKE_LATER = 1;
    public static final int INVOKE_AND_WAIT = 2;
    public static final int PREEMPT_LATER = 3;
    public static final int PREEMPT_AND_WAIT = 4;

    public RunnableQueueTest(int nThreads) {
        this.nThreads = nThreads;
    }

    public RunnableQueueTest(Integer nThreads) {
        this(nThreads == null ? 10 : nThreads);
    }

    @Override
    public String getName() {
        return "RunnableQueue Stress Test";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TestReport runImpl() throws Exception {
        this.rq = RunnableQueue.createRunnableQueue();
        ArrayList<Runnable> l = new ArrayList<Runnable>(this.nThreads);
        this.rand = new Random(2345L);
        l.add(new SwitchFlicker());
        l.add(new SwitchFlicker());
        int i = 0;
        while (i < this.nThreads) {
            RQRable rqRable = new RQRable(i, this.rand.nextInt(50) + 1);
            l.add(new TPRable(this.rq, i, this.rand.nextInt(4) + 1, this.rand.nextInt(500) + 1, 20, rqRable));
            ++i;
        }
        RunnableQueueTest runnableQueueTest = this;
        synchronized (runnableQueueTest) {
            ThreadPounder tp = new ThreadPounder(l);
            tp.start();
            this.activeThreads = this.nThreads;
            while (this.activeThreads != 0) {
                this.wait();
            }
        }
        System.exit(0);
        return null;
    }

    public static void main(String[] args) {
        RunnableQueueTest rqt = new RunnableQueueTest(20);
        try {
            rqt.runImpl();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static class RQRable
    implements Runnable {
        int idx;
        long dur;

        RQRable(int idx, long dur) {
            this.idx = idx;
            this.dur = dur;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                System.out.println("      B Rable #" + this.idx);
                Thread.sleep(this.dur);
                System.out.println("      E Rable #" + this.idx);
                RQRable rQRable = this;
                synchronized (rQRable) {
                    this.notify();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public class SwitchFlicker
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        int time;
                        boolean waitp;
                        boolean suspendp;
                        Random random = RunnableQueueTest.this.rand;
                        synchronized (random) {
                            suspendp = RunnableQueueTest.this.rand.nextBoolean();
                            waitp = RunnableQueueTest.this.rand.nextBoolean();
                            time = RunnableQueueTest.this.rand.nextInt(500);
                        }
                        if (suspendp) {
                            RunnableQueueTest.this.rq.suspendExecution(waitp);
                            System.out.println("Suspended - " + (waitp ? "Wait" : "Later"));
                            Thread.sleep(time / 10);
                            continue;
                        }
                        RunnableQueueTest.this.rq.resumeExecution();
                        System.out.println("Resumed");
                        Thread.sleep(time);
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }

    public class TPRable
    implements Runnable {
        RunnableQueue rq;
        int idx;
        int style;
        long repeatDelay;
        int count;
        Runnable rqRable;

        TPRable(RunnableQueue rq, int idx, int style, long repeatDelay, int count, Runnable rqRable) {
            this.rq = rq;
            this.idx = idx;
            this.style = style;
            this.repeatDelay = repeatDelay;
            this.count = count;
            this.rqRable = rqRable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object;
            try {
                while (this.count-- != 0) {
                    switch (this.style) {
                        case 1: {
                            object = this.rqRable;
                            synchronized (object) {
                                System.out.println("     InvL #" + this.idx);
                                this.rq.invokeLater(this.rqRable);
                                System.out.println("Done InvL #" + this.idx);
                                this.rqRable.wait();
                                break;
                            }
                        }
                        case 2: {
                            System.out.println("     InvW #" + this.idx);
                            this.rq.invokeAndWait(this.rqRable);
                            System.out.println("Done InvW #" + this.idx);
                            break;
                        }
                        case 3: {
                            object = this.rqRable;
                            synchronized (object) {
                                System.out.println("     PreL #" + this.idx);
                                this.rq.preemptLater(this.rqRable);
                                System.out.println("Done PreL #" + this.idx);
                                this.rqRable.wait();
                                break;
                            }
                        }
                        case 4: {
                            System.out.println("     PreW #" + this.idx);
                            this.rq.preemptAndWait(this.rqRable);
                            System.out.println("Done PreW #" + this.idx);
                        }
                    }
                    if (this.repeatDelay >= 0L) {
                        Thread.sleep(this.repeatDelay);
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            object = RunnableQueueTest.this;
            synchronized (object) {
                --RunnableQueueTest.this.activeThreads;
                RunnableQueueTest.this.notify();
            }
        }
    }
}

