/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.complexscripts.fonts;

import org.apache.fop.complexscripts.fonts.GlyphCoverageTable;
import org.apache.fop.complexscripts.fonts.GlyphPositioning;
import org.apache.fop.complexscripts.fonts.GlyphPositioningState;
import org.apache.fop.complexscripts.fonts.GlyphPositioningTable;
import org.apache.fop.complexscripts.fonts.GlyphSubtable;
import org.apache.fop.complexscripts.util.GlyphSequence;
import org.apache.fop.complexscripts.util.ScriptContextTester;

public abstract class GlyphPositioningSubtable
extends GlyphSubtable
implements GlyphPositioning {
    private static final GlyphPositioningState state = new GlyphPositioningState();

    protected GlyphPositioningSubtable(String id, int sequence, int flags, int format, GlyphCoverageTable coverage) {
        super(id, sequence, flags, format, coverage);
    }

    public int getTableType() {
        return 2;
    }

    public String getTypeName() {
        return GlyphPositioningTable.getLookupTypeName(this.getType());
    }

    public boolean isCompatible(GlyphSubtable subtable) {
        return subtable instanceof GlyphPositioningSubtable;
    }

    public boolean usesReverseScan() {
        return false;
    }

    public boolean position(GlyphPositioningState ps) {
        return false;
    }

    public static final boolean position(GlyphPositioningState ps, GlyphPositioningSubtable[] sta, int sequenceIndex) {
        int sequenceStart = ps.getPosition();
        boolean appliedOneShot = false;
        while (ps.hasNext()) {
            boolean applied = false;
            if (!appliedOneShot && ps.maybeApplicable()) {
                int n = sta.length;
                for (int i = 0; !applied && i < n; ++i) {
                    if (sequenceIndex < 0) {
                        applied = ps.apply(sta[i]);
                        continue;
                    }
                    if (ps.getPosition() != sequenceStart + sequenceIndex || !(applied = ps.apply(sta[i]))) continue;
                    appliedOneShot = true;
                }
            }
            if (!applied || !ps.didConsume()) {
                ps.applyDefault();
            }
            ps.next();
        }
        return ps.getAdjusted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean position(GlyphSequence gs, String script, String language, String feature, int fontSize, GlyphPositioningSubtable[] sta, int[] widths, int[][] adjustments, ScriptContextTester sct) {
        GlyphPositioningState glyphPositioningState = state;
        synchronized (glyphPositioningState) {
            return GlyphPositioningSubtable.position(state.reset(gs, script, language, feature, fontSize, widths, adjustments, sct), sta, -1);
        }
    }
}

