/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.URI;
import java.util.List;
import org.apache.fop.fonts.EmbeddingMode;
import org.apache.fop.fonts.EncodingMode;
import org.apache.fop.fonts.FontTriplet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmbedFontInfo
implements Serializable {
    private static final long serialVersionUID = 8755432068669997369L;
    protected final URI metricsURI;
    protected final URI embedURI;
    protected final boolean kerning;
    protected final boolean advanced;
    private final EncodingMode encodingMode;
    private final EmbeddingMode embeddingMode;
    protected String postScriptName;
    protected String subFontName;
    private List<FontTriplet> fontTriplets;
    private transient boolean embedded = true;

    public EmbedFontInfo(URI metricsURI, boolean kerning, boolean advanced, List<FontTriplet> fontTriplets, URI embedURI, String subFontName, EncodingMode encodingMode, EmbeddingMode embeddingMode) {
        this.metricsURI = metricsURI;
        this.embedURI = embedURI;
        this.kerning = kerning;
        this.advanced = advanced;
        this.fontTriplets = fontTriplets;
        this.subFontName = subFontName;
        this.encodingMode = encodingMode;
        this.embeddingMode = embeddingMode;
    }

    public URI getMetricsURI() {
        return this.metricsURI;
    }

    public URI getEmbedURI() {
        return this.embedURI;
    }

    public boolean getKerning() {
        return this.kerning;
    }

    public boolean getAdvanced() {
        return this.advanced;
    }

    public String getSubFontName() {
        return this.subFontName;
    }

    public String getPostScriptName() {
        return this.postScriptName;
    }

    public void setPostScriptName(String postScriptName) {
        this.postScriptName = postScriptName;
    }

    public List<FontTriplet> getFontTriplets() {
        return this.fontTriplets;
    }

    public boolean isEmbedded() {
        if (this.embedURI == null) {
            return false;
        }
        return this.embedded;
    }

    public EmbeddingMode getEmbeddingMode() {
        return this.embeddingMode;
    }

    public void setEmbedded(boolean value) {
        this.embedded = value;
    }

    public EncodingMode getEncodingMode() {
        return this.encodingMode;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.embedded = true;
    }

    public String toString() {
        return "metrics-uri=" + this.metricsURI + ", embed-uri=" + this.embedURI + ", kerning=" + this.kerning + ", advanced=" + this.advanced + ", enc-mode=" + (Object)((Object)this.encodingMode) + ", font-triplet=" + this.fontTriplets + (this.getSubFontName() != null ? ", sub-font=" + this.getSubFontName() : "") + (this.isEmbedded() ? "" : ", NOT embedded");
    }
}

