/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts;

import java.io.IOException;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.apps.io.InternalResourceResolver;
import org.apache.fop.fonts.CustomFont;
import org.apache.fop.fonts.EmbeddingMode;
import org.apache.fop.fonts.EncodingMode;
import org.apache.fop.fonts.truetype.TTFFontLoader;
import org.apache.fop.fonts.type1.Type1FontLoader;

public abstract class FontLoader {
    protected static final Log log = LogFactory.getLog(FontLoader.class);
    protected final URI fontFileURI;
    protected final InternalResourceResolver resourceResolver;
    protected CustomFont returnFont;
    protected boolean loaded;
    protected boolean embedded;
    protected boolean useKerning;
    protected boolean useAdvanced;

    public FontLoader(URI fontFileURI, boolean embedded, boolean useKerning, boolean useAdvanced, InternalResourceResolver resourceResolver) {
        this.fontFileURI = fontFileURI;
        this.embedded = embedded;
        this.useKerning = useKerning;
        this.useAdvanced = useAdvanced;
        this.resourceResolver = resourceResolver;
    }

    private static boolean isType1(URI fontURI) {
        return fontURI.toASCIIString().toLowerCase().endsWith(".pfb");
    }

    public static CustomFont loadFont(URI fontFileURI, String subFontName, boolean embedded, EmbeddingMode embeddingMode, EncodingMode encodingMode, boolean useKerning, boolean useAdvanced, InternalResourceResolver resourceResolver) throws IOException {
        FontLoader loader;
        boolean type1 = FontLoader.isType1(fontFileURI);
        if (type1) {
            if (encodingMode == EncodingMode.CID) {
                throw new IllegalArgumentException("CID encoding mode not supported for Type 1 fonts");
            }
            if (embeddingMode == EmbeddingMode.SUBSET) {
                throw new IllegalArgumentException("Subset embedding for Type 1 fonts is not supported");
            }
            loader = new Type1FontLoader(fontFileURI, embedded, useKerning, resourceResolver);
        } else {
            loader = new TTFFontLoader(fontFileURI, subFontName, embedded, embeddingMode, encodingMode, useKerning, useAdvanced, resourceResolver);
        }
        return loader.getFont();
    }

    protected abstract void read() throws IOException;

    public CustomFont getFont() throws IOException {
        if (!this.loaded) {
            this.read();
        }
        return this.returnFont;
    }
}

