/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts;

import java.net.URI;
import java.util.List;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.io.InternalResourceResolver;
import org.apache.fop.fonts.EmbedFontInfo;
import org.apache.fop.fonts.FontAdder;
import org.apache.fop.fonts.FontCache;
import org.apache.fop.fonts.FontCacheManager;
import org.apache.fop.fonts.FontCacheManagerFactory;
import org.apache.fop.fonts.FontCollection;
import org.apache.fop.fonts.FontDetector;
import org.apache.fop.fonts.FontEventListener;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.FontTriplet;
import org.apache.fop.fonts.substitute.FontSubstitutions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FontManager {
    private InternalResourceResolver resourceResolver;
    private final FontDetector fontDetector;
    private FontCacheManager fontCacheManager;
    private FontSubstitutions fontSubstitutions = null;
    private boolean enableBase14Kerning = false;
    private FontTriplet.Matcher referencedFontsMatcher;

    public FontManager(InternalResourceResolver resourceResolver, FontDetector fontDetector, FontCacheManager fontCacheManager) {
        this.resourceResolver = resourceResolver;
        this.fontDetector = fontDetector;
        this.fontCacheManager = fontCacheManager;
    }

    public void setResourceResolver(InternalResourceResolver resourceResolver) {
        this.resourceResolver = resourceResolver;
    }

    public InternalResourceResolver getResourceResolver() {
        return this.resourceResolver;
    }

    public boolean isBase14KerningEnabled() {
        return this.enableBase14Kerning;
    }

    public void setBase14KerningEnabled(boolean value) {
        this.enableBase14Kerning = value;
    }

    public void setFontSubstitutions(FontSubstitutions substitutions) {
        this.fontSubstitutions = substitutions;
    }

    protected FontSubstitutions getFontSubstitutions() {
        if (this.fontSubstitutions == null) {
            this.fontSubstitutions = new FontSubstitutions();
        }
        return this.fontSubstitutions;
    }

    public void setCacheFile(URI cacheFileURI) {
        this.fontCacheManager.setCacheFile(this.resourceResolver.resolveFromBase(cacheFileURI));
    }

    public void disableFontCache() {
        this.fontCacheManager = FontCacheManagerFactory.createDisabled();
    }

    public FontCache getFontCache() {
        return this.fontCacheManager.load();
    }

    public void saveCache() throws FOPException {
        this.fontCacheManager.save();
    }

    public void deleteCache() throws FOPException {
        this.fontCacheManager.delete();
    }

    public void setup(FontInfo fontInfo, FontCollection[] fontCollections) {
        int startNum = 1;
        int c = fontCollections.length;
        for (int i = 0; i < c; ++i) {
            startNum = fontCollections[i].setup(startNum, fontInfo);
        }
        this.getFontSubstitutions().adjustFontInfo(fontInfo);
    }

    public void setReferencedFontsMatcher(FontTriplet.Matcher matcher) {
        this.referencedFontsMatcher = matcher;
    }

    public FontTriplet.Matcher getReferencedFontsMatcher() {
        return this.referencedFontsMatcher;
    }

    public void updateReferencedFonts(List<EmbedFontInfo> fontInfoList) {
        FontTriplet.Matcher matcher = this.getReferencedFontsMatcher();
        this.updateReferencedFonts(fontInfoList, matcher);
    }

    public void updateReferencedFonts(List<EmbedFontInfo> fontInfoList, FontTriplet.Matcher matcher) {
        if (matcher == null) {
            return;
        }
        block0: for (EmbedFontInfo fontInfo : fontInfoList) {
            for (FontTriplet triplet : fontInfo.getFontTriplets()) {
                if (!matcher.matches(triplet)) continue;
                fontInfo.setEmbedded(false);
                continue block0;
            }
        }
    }

    public void autoDetectFonts(boolean autoDetectFonts, FontAdder fontAdder, boolean strict, FontEventListener listener, List<EmbedFontInfo> fontInfoList) throws FOPException {
        if (autoDetectFonts) {
            this.fontDetector.detect(this, fontAdder, strict, listener, fontInfoList);
        }
    }
}

