/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts;

import java.nio.CharBuffer;
import java.nio.IntBuffer;
import java.util.BitSet;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.apps.io.InternalResourceResolver;
import org.apache.fop.complexscripts.fonts.GlyphDefinitionTable;
import org.apache.fop.complexscripts.fonts.GlyphPositioningTable;
import org.apache.fop.complexscripts.fonts.GlyphSubstitutionTable;
import org.apache.fop.complexscripts.fonts.Positionable;
import org.apache.fop.complexscripts.fonts.Substitutable;
import org.apache.fop.complexscripts.util.GlyphSequence;
import org.apache.fop.fonts.CIDFont;
import org.apache.fop.fonts.CIDFontType;
import org.apache.fop.fonts.CIDFull;
import org.apache.fop.fonts.CIDSet;
import org.apache.fop.fonts.CIDSubset;
import org.apache.fop.fonts.CMapSegment;
import org.apache.fop.fonts.EmbeddingMode;
import org.apache.fop.fonts.FontType;
import org.apache.fop.fonts.FontUtil;
import org.apache.fop.util.CharUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiByteFont
extends CIDFont
implements Substitutable,
Positionable {
    private static final Log log = LogFactory.getLog(MultiByteFont.class);
    private String ttcName;
    private String encoding = "Identity-H";
    private int defaultWidth;
    private CIDFontType cidType = CIDFontType.CIDTYPE2;
    private final CIDSet cidSet;
    private GlyphDefinitionTable gdef;
    private GlyphSubstitutionTable gsub;
    private GlyphPositioningTable gpos;
    private int numMapped;
    private int numUnmapped;
    private int nextPrivateUse = 57344;
    private int firstPrivate;
    private int lastPrivate;
    private int firstUnmapped;
    private int lastUnmapped;

    public MultiByteFont(InternalResourceResolver resourceResolver, EmbeddingMode embeddingMode) {
        super(resourceResolver);
        this.setFontType(FontType.TYPE0);
        this.setEmbeddingMode(embeddingMode);
        this.cidSet = embeddingMode != EmbeddingMode.FULL ? new CIDSubset(this) : new CIDFull(this);
    }

    @Override
    public int getDefaultWidth() {
        return this.defaultWidth;
    }

    @Override
    public String getRegistry() {
        return "Adobe";
    }

    @Override
    public String getOrdering() {
        return "UCS";
    }

    @Override
    public int getSupplement() {
        return 0;
    }

    @Override
    public CIDFontType getCIDType() {
        return this.cidType;
    }

    public void setCIDType(CIDFontType cidType) {
        this.cidType = cidType;
    }

    @Override
    public String getEmbedFontName() {
        if (this.isEmbeddable()) {
            return FontUtil.stripWhiteSpace(super.getFontName());
        }
        return super.getFontName();
    }

    @Override
    public boolean isEmbeddable() {
        return this.getEmbedFileURI() != null || this.getEmbedResourceName() != null;
    }

    @Override
    public boolean isSubsetEmbedded() {
        return this.getEmbeddingMode() != EmbeddingMode.FULL;
    }

    @Override
    public CIDSet getCIDSet() {
        return this.cidSet;
    }

    @Override
    public String getEncodingName() {
        return this.encoding;
    }

    @Override
    public int getWidth(int i, int size) {
        if (this.isEmbeddable()) {
            int glyphIndex = this.cidSet.getOriginalGlyphIndex(i);
            return size * this.width[glyphIndex];
        }
        return size * this.width[i];
    }

    @Override
    public int[] getWidths() {
        int[] arr = new int[this.width.length];
        System.arraycopy(this.width, 0, arr, 0, this.width.length);
        return arr;
    }

    private int findGlyphIndex(int c) {
        int idx = c;
        int retIdx = 0;
        for (int i = 0; i < this.cmap.length && retIdx == 0; ++i) {
            if (this.cmap[i].getUnicodeStart() > idx || this.cmap[i].getUnicodeEnd() < idx) continue;
            retIdx = this.cmap[i].getGlyphStartIndex() + idx - this.cmap[i].getUnicodeStart();
        }
        return retIdx;
    }

    private synchronized void addPrivateUseMapping(int pu, int gi) {
        assert (this.findGlyphIndex(pu) == 0);
        CMapSegment[] oldCmap = this.cmap;
        int cmapLength = oldCmap.length;
        CMapSegment[] newCmap = new CMapSegment[cmapLength + 1];
        System.arraycopy(oldCmap, 0, newCmap, 0, cmapLength);
        newCmap[cmapLength] = new CMapSegment(pu, pu, gi);
        this.cmap = newCmap;
    }

    private int createPrivateUseMapping(int gi) {
        while (this.nextPrivateUse < 63744 && this.findGlyphIndex(this.nextPrivateUse) != 0) {
            ++this.nextPrivateUse;
        }
        if (this.nextPrivateUse < 63744) {
            int pu = this.nextPrivateUse;
            this.addPrivateUseMapping(pu, gi);
            if (this.firstPrivate == 0) {
                this.firstPrivate = pu;
            }
            this.lastPrivate = pu;
            ++this.numMapped;
            if (log.isDebugEnabled()) {
                log.debug("Create private use mapping from " + CharUtilities.format(pu) + " to glyph index " + gi + " in font '" + this.getFullName() + "'");
            }
            return pu;
        }
        if (this.firstUnmapped == 0) {
            this.firstUnmapped = gi;
        }
        this.lastUnmapped = gi;
        ++this.numUnmapped;
        log.warn("Exhausted private use area: unable to map " + this.numUnmapped + " glyphs in glyph index range [" + this.firstUnmapped + "," + this.lastUnmapped + "] (inclusive) of font '" + this.getFullName() + "'");
        return 0;
    }

    private int findCharacterFromGlyphIndex(int gi, boolean augment) {
        int cc = 0;
        for (CMapSegment segment : this.cmap) {
            int s = segment.getGlyphStartIndex();
            int e = s + (segment.getUnicodeEnd() - segment.getUnicodeStart());
            if (gi < s || gi > e) continue;
            cc = segment.getUnicodeStart() + (gi - s);
            break;
        }
        if (cc == 0 && augment) {
            cc = this.createPrivateUseMapping(gi);
        }
        return cc;
    }

    private int findCharacterFromGlyphIndex(int gi) {
        return this.findCharacterFromGlyphIndex(gi, true);
    }

    @Override
    public char mapChar(char c) {
        this.notifyMapOperation();
        int glyphIndex = this.findGlyphIndex(c);
        if (glyphIndex == 0) {
            this.warnMissingGlyph(c);
            glyphIndex = this.findGlyphIndex(35);
        }
        if (this.isEmbeddable()) {
            glyphIndex = this.cidSet.mapChar(glyphIndex, c);
        }
        return (char)glyphIndex;
    }

    protected BitSet getGlyphIndices() {
        BitSet bitset = new BitSet();
        bitset.set(0);
        bitset.set(1);
        bitset.set(2);
        for (int i = 0; i < this.cmap.length; ++i) {
            int start = this.cmap[i].getUnicodeStart();
            int end = this.cmap[i].getUnicodeEnd();
            int glyphIndex = this.cmap[i].getGlyphStartIndex();
            while (start++ < end + 1) {
                bitset.set(glyphIndex++);
            }
        }
        return bitset;
    }

    protected char[] getChars() {
        char[] chars = new char[this.width.length];
        for (int i = 0; i < this.cmap.length; ++i) {
            int start = this.cmap[i].getUnicodeStart();
            int end = this.cmap[i].getUnicodeEnd();
            int glyphIndex = this.cmap[i].getGlyphStartIndex();
            while (start < end + 1) {
                chars[glyphIndex++] = (char)start++;
            }
        }
        return chars;
    }

    @Override
    public boolean hasChar(char c) {
        return this.findGlyphIndex(c) != 0;
    }

    public void setDefaultWidth(int defaultWidth) {
        this.defaultWidth = defaultWidth;
    }

    public String getTTCName() {
        return this.ttcName;
    }

    public void setTTCName(String ttcName) {
        this.ttcName = ttcName;
    }

    public void setWidthArray(int[] wds) {
        this.width = wds;
    }

    public Map<Integer, Integer> getUsedGlyphs() {
        return this.cidSet.getGlyphs();
    }

    public void setGDEF(GlyphDefinitionTable gdef) {
        if (this.gdef != null && gdef != null) {
            throw new IllegalStateException("font already associated with GDEF table");
        }
        this.gdef = gdef;
    }

    public GlyphDefinitionTable getGDEF() {
        return this.gdef;
    }

    public void setGSUB(GlyphSubstitutionTable gsub) {
        if (this.gsub != null && gsub != null) {
            throw new IllegalStateException("font already associated with GSUB table");
        }
        this.gsub = gsub;
    }

    public GlyphSubstitutionTable getGSUB() {
        return this.gsub;
    }

    public void setGPOS(GlyphPositioningTable gpos) {
        if (this.gpos != null && gpos != null) {
            throw new IllegalStateException("font already associated with GPOS table");
        }
        this.gpos = gpos;
    }

    public GlyphPositioningTable getGPOS() {
        return this.gpos;
    }

    @Override
    public boolean performsSubstitution() {
        return this.gsub != null;
    }

    @Override
    public CharSequence performSubstitution(CharSequence cs, String script, String language) {
        if (this.gsub != null) {
            GlyphSequence igs = this.mapCharsToGlyphs(cs);
            GlyphSequence ogs = this.gsub.substitute(igs, script, language);
            CharSequence ocs = this.mapGlyphsToChars(ogs);
            return ocs;
        }
        return cs;
    }

    @Override
    public CharSequence reorderCombiningMarks(CharSequence cs, int[][] gpa, String script, String language) {
        if (this.gdef != null) {
            GlyphSequence igs = this.mapCharsToGlyphs(cs);
            GlyphSequence ogs = this.gdef.reorderCombiningMarks(igs, gpa, script, language);
            CharSequence ocs = this.mapGlyphsToChars(ogs);
            return ocs;
        }
        return cs;
    }

    @Override
    public boolean performsPositioning() {
        return this.gpos != null;
    }

    @Override
    public int[][] performPositioning(CharSequence cs, String script, String language, int fontSize) {
        if (this.gpos != null) {
            int[][] adjustments;
            GlyphSequence gs = this.mapCharsToGlyphs(cs);
            if (this.gpos.position(gs, script, language, fontSize, this.width, adjustments = new int[gs.getGlyphCount()][4])) {
                return this.scaleAdjustments(adjustments, fontSize);
            }
            return null;
        }
        return null;
    }

    @Override
    public int[][] performPositioning(CharSequence cs, String script, String language) {
        throw new UnsupportedOperationException();
    }

    private int[][] scaleAdjustments(int[][] adjustments, int fontSize) {
        if (adjustments != null) {
            int n = adjustments.length;
            for (int i = 0; i < n; ++i) {
                int[] gpa = adjustments[i];
                for (int k = 0; k < 4; ++k) {
                    gpa[k] = gpa[k] * fontSize / 1000;
                }
            }
            return adjustments;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private GlyphSequence mapCharsToGlyphs(CharSequence cs) {
        IntBuffer cb = IntBuffer.allocate(cs.length());
        IntBuffer gb = IntBuffer.allocate(cs.length());
        int giMissing = this.findGlyphIndex(35);
        int n = cs.length();
        for (int i = 0; i < n; ++i) {
            int cc = cs.charAt(i);
            if (cc >= 55296 && cc < 56320) {
                char sl;
                if (i + 1 >= n) throw new IllegalArgumentException("ill-formed UTF-16 sequence, contains isolated high surrogate at end of sequence");
                int sh = cc;
                if ((sl = cs.charAt(++i)) < '\udc00' || sl >= '\ue000') throw new IllegalArgumentException("ill-formed UTF-16 sequence, contains isolated high surrogate at index " + i);
                cc = 65536 + (sh - 55296 << 10) + (sl - 56320 << 0);
            } else if (cc >= 56320 && cc < 57344) {
                throw new IllegalArgumentException("ill-formed UTF-16 sequence, contains isolated low surrogate at index " + i);
            }
            this.notifyMapOperation();
            int gi = this.findGlyphIndex(cc);
            if (gi == 0) {
                this.warnMissingGlyph((char)cc);
                gi = giMissing;
            }
            cb.put(cc);
            gb.put(gi);
        }
        cb.flip();
        gb.flip();
        return new GlyphSequence(cb, gb, null);
    }

    private CharSequence mapGlyphsToChars(GlyphSequence gs) {
        int ng = gs.getGlyphCount();
        CharBuffer cb = CharBuffer.allocate(ng);
        int ccMissing = 35;
        int n = ng;
        for (int i = 0; i < n; ++i) {
            int gi = gs.getGlyph(i);
            int cc = this.findCharacterFromGlyphIndex(gi);
            if (cc == 0 || cc > 0x10FFFF) {
                cc = ccMissing;
                log.warn("Unable to map glyph index " + gi + " to Unicode scalar in font '" + this.getFullName() + "', substituting missing character '" + (char)cc + "'");
            }
            if (cc > 65535) {
                int sh = ((cc -= 65536) >> 10 & 0x3FF) + 55296;
                int sl = (cc >> 0 & 0x3FF) + 56320;
                cb.put((char)sh);
                cb.put((char)sl);
                continue;
            }
            cb.put((char)cc);
        }
        cb.flip();
        return cb;
    }
}

