/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFStructElem;
import org.apache.fop.pdf.StandardStructureAttributes;
import org.apache.fop.pdf.Version;

public abstract class VersionController {
    private Version version;

    private VersionController(Version version) {
        this.version = version;
    }

    public Version getPDFVersion() {
        return this.version;
    }

    public abstract void setPDFVersion(Version var1);

    abstract void addTableHeaderScopeAttribute(PDFStructElem var1, StandardStructureAttributes.Table.Scope var2);

    public String toString() {
        return this.version.toString();
    }

    public static VersionController getFixedVersionController(Version version) {
        if (version.compareTo(Version.V1_4) < 0) {
            throw new IllegalArgumentException("The PDF version cannot be set below version 1.4");
        }
        return new FixedVersion(version);
    }

    public static VersionController getDynamicVersionController(Version initialVersion, PDFDocument doc) {
        return new DynamicVersion(initialVersion, doc);
    }

    private static final class DynamicVersion
    extends VersionController {
        private PDFDocument doc;

        private DynamicVersion(Version version, PDFDocument doc) {
            super(version);
            this.doc = doc;
        }

        public void setPDFVersion(Version version) {
            if (((VersionController)this).version.compareTo(version) < 0) {
                ((VersionController)this).version = version;
                this.doc.getRoot().setVersion(version);
            }
        }

        void addTableHeaderScopeAttribute(PDFStructElem th, StandardStructureAttributes.Table.Scope scope) {
            this.setPDFVersion(Version.V1_5);
            StandardStructureAttributes.Table.Scope.addScopeAttribute(th, scope);
        }
    }

    private static final class FixedVersion
    extends VersionController {
        private FixedVersion(Version version) {
            super(version);
        }

        public void setPDFVersion(Version version) {
            throw new IllegalStateException("Cannot change the version of this PDF document.");
        }

        void addTableHeaderScopeAttribute(PDFStructElem th, StandardStructureAttributes.Table.Scope scope) {
            if (((VersionController)this).version.compareTo(Version.V1_4) > 0) {
                StandardStructureAttributes.Table.Scope.addScopeAttribute(th, scope);
            }
        }
    }
}

