/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import org.apache.fop.accessibility.StructureTreeElement;
import org.apache.fop.accessibility.StructureTreeEventHandler;
import org.apache.fop.events.EventBroadcaster;
import org.apache.fop.pdf.PDFFactory;
import org.apache.fop.pdf.PDFObject;
import org.apache.fop.pdf.PDFParentTree;
import org.apache.fop.pdf.PDFStructElem;
import org.apache.fop.pdf.PDFStructTreeRoot;
import org.apache.fop.pdf.StandardStructureAttributes;
import org.apache.fop.pdf.StandardStructureTypes;
import org.apache.fop.pdf.StructureHierarchyMember;
import org.apache.fop.pdf.StructureType;
import org.apache.fop.render.pdf.PDFEventProducer;
import org.apache.fop.render.pdf.PDFLogicalStructureHandler;
import org.apache.fop.render.pdf.PageSequenceStructElem;
import org.apache.fop.render.pdf.TableStructElem;
import org.apache.fop.util.LanguageTags;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

class PDFStructureTreeBuilder
implements StructureTreeEventHandler {
    private static final String ROLE = "role";
    private static final Map<String, StructureElementBuilder> BUILDERS = new HashMap<String, StructureElementBuilder>();
    private static final StructureElementBuilder DEFAULT_BUILDER = new DefaultStructureElementBuilder(StandardStructureTypes.Grouping.NON_STRUCT);
    private PDFFactory pdfFactory;
    private EventBroadcaster eventBroadcaster;
    private LinkedList<PDFStructElem> ancestors = new LinkedList();
    private PDFStructElem rootStructureElement;

    PDFStructureTreeBuilder() {
    }

    private static void addBuilder(String fo, StructureType structureType) {
        PDFStructureTreeBuilder.addBuilder(fo, new DefaultStructureElementBuilder(structureType));
    }

    private static void addBuilder(String fo, StructureElementBuilder mapper) {
        BUILDERS.put(fo, mapper);
    }

    void setPdfFactory(PDFFactory pdfFactory) {
        this.pdfFactory = pdfFactory;
    }

    void setEventBroadcaster(EventBroadcaster eventBroadcaster) {
        this.eventBroadcaster = eventBroadcaster;
    }

    void setLogicalStructureHandler(PDFLogicalStructureHandler logicalStructureHandler) {
        this.createRootStructureElement(logicalStructureHandler);
    }

    private void createRootStructureElement(PDFLogicalStructureHandler logicalStructureHandler) {
        assert (this.rootStructureElement == null);
        PDFParentTree parentTree = logicalStructureHandler.getParentTree();
        PDFStructTreeRoot structTreeRoot = this.pdfFactory.getDocument().makeStructTreeRoot(parentTree);
        this.rootStructureElement = PDFStructureTreeBuilder.createStructureElement("root", structTreeRoot, new AttributesImpl(), this.pdfFactory, this.eventBroadcaster);
    }

    private static PDFStructElem createStructureElement(String name, StructureHierarchyMember parent, Attributes attributes, PDFFactory pdfFactory, EventBroadcaster eventBroadcaster) {
        StructureElementBuilder builder = BUILDERS.get(name);
        if (builder == null) {
            builder = DEFAULT_BUILDER;
        }
        return builder.build(parent, attributes, pdfFactory, eventBroadcaster);
    }

    public void startPageSequence(Locale language, String role) {
        this.ancestors = new LinkedList();
        AttributesImpl attributes = new AttributesImpl();
        attributes.addAttribute("", ROLE, ROLE, "CDATA", role);
        PDFStructElem structElem = PDFStructureTreeBuilder.createStructureElement("page-sequence", this.rootStructureElement, attributes, this.pdfFactory, this.eventBroadcaster);
        if (language != null) {
            structElem.setLanguage(language);
        }
        this.ancestors.add(structElem);
    }

    public void endPageSequence() {
    }

    public StructureTreeElement startNode(String name, Attributes attributes) {
        PDFStructElem parent = this.ancestors.getFirst();
        PDFStructElem structElem = PDFStructureTreeBuilder.createStructureElement(name, parent, attributes, this.pdfFactory, this.eventBroadcaster);
        this.ancestors.addFirst(structElem);
        return structElem;
    }

    public void endNode(String name) {
        this.ancestors.removeFirst();
    }

    public StructureTreeElement startImageNode(String name, Attributes attributes) {
        return this.startNode(name, attributes);
    }

    public StructureTreeElement startReferencedNode(String name, Attributes attributes) {
        return this.startNode(name, attributes);
    }

    static {
        RegionBuilder regionBuilder = new RegionBuilder();
        PDFStructureTreeBuilder.addBuilder("root", StandardStructureTypes.Grouping.DOCUMENT);
        PDFStructureTreeBuilder.addBuilder("page-sequence", new PageSequenceBuilder());
        PDFStructureTreeBuilder.addBuilder("static-content", regionBuilder);
        PDFStructureTreeBuilder.addBuilder("flow", regionBuilder);
        PDFStructureTreeBuilder.addBuilder("block", new LanguageHolderBuilder(StandardStructureTypes.Paragraphlike.P));
        PDFStructureTreeBuilder.addBuilder("block-container", StandardStructureTypes.Grouping.DIV);
        PDFStructureTreeBuilder.addBuilder("character", new LanguageHolderBuilder(StandardStructureTypes.InlineLevelStructure.SPAN));
        PDFStructureTreeBuilder.addBuilder("external-graphic", new ImageBuilder());
        PDFStructureTreeBuilder.addBuilder("instream-foreign-object", new ImageBuilder());
        PDFStructureTreeBuilder.addBuilder("inline", StandardStructureTypes.InlineLevelStructure.SPAN);
        PDFStructureTreeBuilder.addBuilder("inline-container", StandardStructureTypes.Grouping.DIV);
        PDFStructureTreeBuilder.addBuilder("page-number", StandardStructureTypes.InlineLevelStructure.QUOTE);
        PDFStructureTreeBuilder.addBuilder("page-number-citation", StandardStructureTypes.InlineLevelStructure.QUOTE);
        PDFStructureTreeBuilder.addBuilder("page-number-citation-last", StandardStructureTypes.InlineLevelStructure.QUOTE);
        PDFStructureTreeBuilder.addBuilder("table-and-caption", StandardStructureTypes.Grouping.DIV);
        PDFStructureTreeBuilder.addBuilder("table", new TableBuilder());
        PDFStructureTreeBuilder.addBuilder("table-caption", StandardStructureTypes.Grouping.CAPTION);
        PDFStructureTreeBuilder.addBuilder("table-header", StandardStructureTypes.Table.THEAD);
        PDFStructureTreeBuilder.addBuilder("table-footer", new TableFooterBuilder());
        PDFStructureTreeBuilder.addBuilder("table-body", StandardStructureTypes.Table.TBODY);
        PDFStructureTreeBuilder.addBuilder("table-row", StandardStructureTypes.Table.TR);
        PDFStructureTreeBuilder.addBuilder("table-cell", new TableCellBuilder());
        PDFStructureTreeBuilder.addBuilder("list-block", StandardStructureTypes.List.L);
        PDFStructureTreeBuilder.addBuilder("list-item", StandardStructureTypes.List.LI);
        PDFStructureTreeBuilder.addBuilder("list-item-body", StandardStructureTypes.List.LBODY);
        PDFStructureTreeBuilder.addBuilder("list-item-label", StandardStructureTypes.List.LBL);
        PDFStructureTreeBuilder.addBuilder("basic-link", StandardStructureTypes.InlineLevelStructure.LINK);
        PDFStructureTreeBuilder.addBuilder("float", StandardStructureTypes.Grouping.DIV);
        PDFStructureTreeBuilder.addBuilder("footnote", StandardStructureTypes.InlineLevelStructure.NOTE);
        PDFStructureTreeBuilder.addBuilder("footnote-body", StandardStructureTypes.Grouping.SECT);
        PDFStructureTreeBuilder.addBuilder("wrapper", StandardStructureTypes.InlineLevelStructure.SPAN);
        PDFStructureTreeBuilder.addBuilder("marker", StandardStructureTypes.Grouping.PRIVATE);
        PDFStructureTreeBuilder.addBuilder("#PCDATA", new PlaceholderBuilder());
    }

    private static class PlaceholderBuilder
    implements StructureElementBuilder {
        private PlaceholderBuilder() {
        }

        public PDFStructElem build(StructureHierarchyMember parent, Attributes attributes, PDFFactory pdfFactory, EventBroadcaster eventBroadcaster) {
            PDFStructElem.Placeholder elem = new PDFStructElem.Placeholder(parent);
            parent.addKid(elem);
            return elem;
        }
    }

    private static class TableCellBuilder
    extends DefaultStructureElementBuilder {
        TableCellBuilder() {
            super(StandardStructureTypes.Table.TD);
        }

        protected void registerStructureElement(PDFStructElem structureElement, PDFFactory pdfFactory, Attributes attributes) {
            if (structureElement.getStructureType() == StandardStructureTypes.Table.TH) {
                String scopeAttribute = attributes.getValue("http://xmlgraphics.apache.org/fop/internal", "scope");
                StandardStructureAttributes.Table.Scope scope = scopeAttribute == null ? StandardStructureAttributes.Table.Scope.COLUMN : StandardStructureAttributes.Table.Scope.valueOf(scopeAttribute.toUpperCase(Locale.ENGLISH));
                pdfFactory.getDocument().registerStructureElement(structureElement, scope);
            } else {
                pdfFactory.getDocument().registerStructureElement(structureElement);
            }
        }

        protected void setAttributes(PDFStructElem structElem, Attributes attributes) {
            String rowSpan;
            String columnSpan = attributes.getValue("number-columns-spanned");
            if (columnSpan != null) {
                structElem.setTableAttributeColSpan(Integer.parseInt(columnSpan));
            }
            if ((rowSpan = attributes.getValue("number-rows-spanned")) != null) {
                structElem.setTableAttributeRowSpan(Integer.parseInt(rowSpan));
            }
        }
    }

    private static class TableFooterBuilder
    extends DefaultStructureElementBuilder {
        public TableFooterBuilder() {
            super(StandardStructureTypes.Table.TFOOT);
        }

        protected void addKidToParent(PDFStructElem kid, StructureHierarchyMember parent, Attributes attributes) {
            ((TableStructElem)parent).addTableFooter(kid);
        }
    }

    private static class TableBuilder
    extends DefaultStructureElementBuilder {
        TableBuilder() {
            super(StandardStructureTypes.Table.TABLE);
        }

        protected PDFStructElem createStructureElement(StructureHierarchyMember parent, StructureType structureType) {
            return new TableStructElem(parent, structureType);
        }
    }

    private static class ImageBuilder
    extends DefaultStructureElementBuilder {
        ImageBuilder() {
            super(StandardStructureTypes.Illustration.FIGURE);
        }

        protected void setAttributes(PDFStructElem structElem, Attributes attributes) {
            String altTextNode = attributes.getValue("http://xmlgraphics.apache.org/fop/extensions", "alt-text");
            if (altTextNode == null) {
                altTextNode = "No alternate text specified";
            }
            structElem.put("Alt", altTextNode);
        }
    }

    private static class LanguageHolderBuilder
    extends DefaultStructureElementBuilder {
        LanguageHolderBuilder(StructureType structureType) {
            super(structureType);
        }

        protected void setAttributes(PDFStructElem structElem, Attributes attributes) {
            String xmlLang = attributes.getValue("http://www.w3.org/XML/1998/namespace", "lang");
            if (xmlLang != null) {
                Locale locale = LanguageTags.toLocale((String)xmlLang);
                structElem.setLanguage(locale);
            }
        }
    }

    private static class RegionBuilder
    extends DefaultStructureElementBuilder {
        RegionBuilder() {
            super(StandardStructureTypes.Grouping.SECT);
        }

        protected void addKidToParent(PDFStructElem kid, StructureHierarchyMember parent, Attributes attributes) {
            String flowName = attributes.getValue("flow-name");
            ((PageSequenceStructElem)parent).addContent(flowName, kid);
        }
    }

    private static class PageSequenceBuilder
    extends DefaultStructureElementBuilder {
        PageSequenceBuilder() {
            super(StandardStructureTypes.Grouping.PART);
        }

        protected PDFStructElem createStructureElement(StructureHierarchyMember parent, StructureType structureType) {
            return new PageSequenceStructElem(parent, structureType);
        }
    }

    private static class DefaultStructureElementBuilder
    implements StructureElementBuilder {
        private final StructureType defaultStructureType;

        DefaultStructureElementBuilder(StructureType structureType) {
            this.defaultStructureType = structureType;
        }

        public final PDFStructElem build(StructureHierarchyMember parent, Attributes attributes, PDFFactory pdfFactory, EventBroadcaster eventBroadcaster) {
            StructureType structureType;
            String role = attributes.getValue(PDFStructureTreeBuilder.ROLE);
            if (role == null) {
                structureType = this.defaultStructureType;
            } else {
                structureType = StandardStructureTypes.get(role);
                if (structureType == null) {
                    structureType = this.defaultStructureType;
                    PDFEventProducer.Provider.get(eventBroadcaster).nonStandardStructureType(role, role, structureType.toString());
                }
            }
            PDFStructElem structElem = this.createStructureElement(parent, structureType);
            this.setAttributes(structElem, attributes);
            this.addKidToParent(structElem, parent, attributes);
            this.registerStructureElement(structElem, pdfFactory, attributes);
            return structElem;
        }

        protected PDFStructElem createStructureElement(StructureHierarchyMember parent, StructureType structureType) {
            return new PDFStructElem((PDFObject)parent, structureType);
        }

        protected void setAttributes(PDFStructElem structElem, Attributes attributes) {
        }

        protected void addKidToParent(PDFStructElem kid, StructureHierarchyMember parent, Attributes attributes) {
            parent.addKid(kid);
        }

        protected void registerStructureElement(PDFStructElem structureElement, PDFFactory pdfFactory, Attributes attributes) {
            pdfFactory.getDocument().registerStructureElement(structureElement);
        }
    }

    private static interface StructureElementBuilder {
        public PDFStructElem build(StructureHierarchyMember var1, Attributes var2, PDFFactory var3, EventBroadcaster var4);
    }
}

