/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.ps;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.text.AttributedCharacterIterator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.batik.gvt.font.GVTGlyphVector;
import org.apache.batik.gvt.renderer.StrokingTextPainter;
import org.apache.batik.gvt.text.TextPaintInfo;
import org.apache.batik.gvt.text.TextSpanLayout;
import org.apache.fop.fonts.Font;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.FontMetrics;
import org.apache.fop.fonts.LazyFont;
import org.apache.fop.fonts.MultiByteFont;
import org.apache.fop.render.ps.FontResourceCache;
import org.apache.fop.render.ps.PSFontResource;
import org.apache.fop.svg.NativeTextPainter;
import org.apache.fop.util.CharUtilities;
import org.apache.fop.util.HexEncoder;
import org.apache.xmlgraphics.java2d.ps.PSGraphics2D;
import org.apache.xmlgraphics.ps.PSGenerator;

public class PSTextPainter
extends NativeTextPainter {
    private static final boolean DEBUG = false;
    private FontResourceCache fontResources;
    private static final AffineTransform IDENTITY_TRANSFORM = new AffineTransform();

    public PSTextPainter(FontInfo fontInfo) {
        super(fontInfo);
        this.fontResources = new FontResourceCache(fontInfo);
    }

    protected boolean isSupported(Graphics2D g2d) {
        return g2d instanceof PSGraphics2D;
    }

    protected void paintTextRun(StrokingTextPainter.TextRun textRun, Graphics2D g2d) throws IOException {
        AttributedCharacterIterator runaci = textRun.getACI();
        runaci.first();
        TextPaintInfo tpi = (TextPaintInfo)runaci.getAttribute(PAINT_INFO);
        if (tpi == null || !tpi.visible) {
            return;
        }
        if (tpi != null && tpi.composite != null) {
            g2d.setComposite(tpi.composite);
        }
        TextSpanLayout layout = textRun.getLayout();
        this.logTextRun(runaci, layout);
        CharSequence chars = this.collectCharacters(runaci);
        runaci.first();
        PSGraphics2D ps = (PSGraphics2D)g2d;
        PSGenerator gen = ps.getPSGenerator();
        ps.preparePainting();
        Object debugShapes = null;
        TextUtil textUtil = new TextUtil(gen);
        textUtil.setupFonts(runaci);
        if (!textUtil.hasFonts()) {
            textRun.getLayout().draw(g2d);
            return;
        }
        gen.saveGraphicsState();
        gen.concatMatrix(g2d.getTransform());
        Shape imclip = g2d.getClip();
        this.clip(ps, imclip);
        gen.writeln("BT");
        AffineTransform localTransform = new AffineTransform();
        Point2D prevPos = null;
        GVTGlyphVector gv = layout.getGlyphVector();
        PSTextRun psRun = new PSTextRun();
        int c = gv.getNumGlyphs();
        for (int index = 0; index < c; ++index) {
            char mapped;
            char paintChar;
            Font f;
            boolean fontChanging;
            char ch = chars.charAt(index);
            boolean visibleChar = gv.isGlyphVisible(index) || CharUtilities.isAnySpace(ch) && !CharUtilities.isZeroWidthSpace(ch);
            this.logCharacter(ch, layout, index, visibleChar);
            if (!visibleChar) continue;
            Point2D glyphPos = gv.getGlyphPosition(index);
            AffineTransform glyphTransform = gv.getGlyphTransform(index);
            if (this.log.isTraceEnabled()) {
                this.log.trace("pos " + glyphPos + ", transform " + glyphTransform);
            }
            localTransform.setToIdentity();
            localTransform.translate(glyphPos.getX(), glyphPos.getY());
            if (glyphTransform != null) {
                localTransform.concatenate(glyphTransform);
            }
            localTransform.scale(1.0, -1.0);
            boolean flushCurrentRun = false;
            if (glyphTransform != null) {
                flushCurrentRun = true;
            }
            if (psRun.getRunLength() >= 128) {
                flushCurrentRun = true;
            }
            Point2D.Double relPos = prevPos == null ? new Point2D.Double(0.0, 0.0) : new Point2D.Double(glyphPos.getX() - prevPos.getX(), glyphPos.getY() - prevPos.getY());
            if (psRun.vertChanges == 0 && psRun.getHorizRunLength() > 2 && ((Point2D)relPos).getY() != 0.0) {
                flushCurrentRun = true;
            }
            if (fontChanging = textUtil.isFontChanging(f = textUtil.selectFontForChar(paintChar = CharUtilities.isAnySpace(ch) ? (char)' ' : (char)ch), mapped = f.mapChar(ch))) {
                flushCurrentRun = true;
            }
            if (flushCurrentRun) {
                psRun.paint(ps, textUtil, tpi);
                psRun.reset();
            }
            psRun.addCharacter(paintChar, relPos);
            psRun.noteStartingTransformation(localTransform);
            if (fontChanging) {
                textUtil.setCurrentFont(f, mapped);
            }
            prevPos = glyphPos;
        }
        psRun.paint(ps, textUtil, tpi);
        gen.writeln("ET");
        gen.restoreGraphicsState();
    }

    private void applyColor(Paint paint, PSGenerator gen) throws IOException {
        if (paint == null) {
            return;
        }
        if (paint instanceof Color) {
            Color col = (Color)paint;
            gen.useColor(col);
        } else {
            this.log.warn("Paint not supported: " + paint.toString());
        }
    }

    private PSFontResource getResourceForFont(Font f, String postfix) {
        String key = postfix != null ? f.getFontName() + '_' + postfix : f.getFontName();
        return this.fontResources.getFontResourceForFontKey(key);
    }

    private void clip(PSGraphics2D ps, Shape shape) throws IOException {
        if (shape == null) {
            return;
        }
        ps.getPSGenerator().writeln("newpath");
        PathIterator iter = shape.getPathIterator(IDENTITY_TRANSFORM);
        ps.processPathIterator(iter);
        ps.getPSGenerator().writeln("clip");
    }

    private class PSTextRun {
        private AffineTransform textTransform;
        private List relativePositions = new LinkedList();
        private StringBuffer currentChars = new StringBuffer();
        private int horizChanges = 0;
        private int vertChanges = 0;

        private PSTextRun() {
        }

        public void reset() {
            this.textTransform = null;
            this.currentChars.setLength(0);
            this.horizChanges = 0;
            this.vertChanges = 0;
            this.relativePositions.clear();
        }

        public int getHorizRunLength() {
            if (this.vertChanges == 0 && this.getRunLength() > 0) {
                return this.getRunLength();
            }
            return 0;
        }

        public void addCharacter(char paintChar, Point2D relPos) {
            this.addRelativePosition(relPos);
            this.currentChars.append(paintChar);
        }

        private void addRelativePosition(Point2D relPos) {
            if (this.getRunLength() > 0) {
                if (relPos.getX() != 0.0) {
                    ++this.horizChanges;
                }
                if (relPos.getY() != 0.0) {
                    ++this.vertChanges;
                }
            }
            this.relativePositions.add(relPos);
        }

        public void noteStartingTransformation(AffineTransform transform) {
            if (this.textTransform == null) {
                this.textTransform = new AffineTransform(transform);
            }
        }

        public int getRunLength() {
            return this.currentChars.length();
        }

        private boolean isXShow() {
            return this.vertChanges == 0;
        }

        private boolean isYShow() {
            return this.horizChanges == 0;
        }

        public void paint(PSGraphics2D g2d, TextUtil textUtil, TextPaintInfo tpi) throws IOException {
            if (this.getRunLength() > 0) {
                boolean stroke;
                if (PSTextPainter.this.log.isDebugEnabled()) {
                    PSTextPainter.this.log.debug("Text run: " + this.currentChars);
                }
                textUtil.writeTextMatrix(this.textTransform);
                if (this.isXShow()) {
                    PSTextPainter.this.log.debug("Horizontal text: xshow");
                    this.paintXYShow(g2d, textUtil, tpi.fillPaint, true, false);
                } else if (this.isYShow()) {
                    PSTextPainter.this.log.debug("Vertical text: yshow");
                    this.paintXYShow(g2d, textUtil, tpi.fillPaint, false, true);
                } else {
                    PSTextPainter.this.log.debug("Arbitrary text: xyshow");
                    this.paintXYShow(g2d, textUtil, tpi.fillPaint, true, true);
                }
                boolean bl = stroke = tpi.strokePaint != null && tpi.strokeStroke != null;
                if (stroke) {
                    PSTextPainter.this.log.debug("Stroked glyph outlines");
                    this.paintStrokedGlyphs(g2d, textUtil, tpi.strokePaint, tpi.strokeStroke);
                }
            }
        }

        private void paintXYShow(PSGraphics2D g2d, TextUtil textUtil, Paint paint, boolean x, boolean y) throws IOException {
            PSGenerator gen = textUtil.gen;
            char firstChar = this.currentChars.charAt(0);
            Font f = textUtil.selectFontForChar(firstChar);
            char mapped = f.mapChar(firstChar);
            textUtil.selectFont(f, mapped);
            textUtil.setCurrentFont(f, mapped);
            PSTextPainter.this.applyColor(paint, gen);
            boolean multiByte = textUtil.isMultiByte(f);
            StringBuffer sb = new StringBuffer();
            sb.append(multiByte ? (char)'<' : '(');
            int c = this.currentChars.length();
            for (int i = 0; i < c; ++i) {
                char ch = this.currentChars.charAt(i);
                mapped = f.mapChar(ch);
                if (multiByte) {
                    sb.append(HexEncoder.encode(mapped));
                    continue;
                }
                char codepoint = (char)(mapped % 256);
                PSGenerator.escapeChar(codepoint, sb);
            }
            sb.append(multiByte ? (char)'>' : ')');
            if (x || y) {
                sb.append("\n[");
                int idx = 0;
                for (Point2D pt : this.relativePositions) {
                    if (idx > 0) {
                        if (x) {
                            sb.append(this.format(gen, pt.getX()));
                        }
                        if (y) {
                            if (x) {
                                sb.append(' ');
                            }
                            sb.append(this.format(gen, -pt.getY()));
                        }
                        if (idx % 8 == 0) {
                            sb.append('\n');
                        } else {
                            sb.append(' ');
                        }
                    }
                    ++idx;
                }
                if (x) {
                    sb.append('0');
                }
                if (y) {
                    if (x) {
                        sb.append(' ');
                    }
                    sb.append('0');
                }
                sb.append(']');
            }
            sb.append(' ');
            if (x) {
                sb.append('x');
            }
            if (y) {
                sb.append('y');
            }
            sb.append("show");
            gen.writeln(sb.toString());
        }

        private String format(PSGenerator gen, double coord) {
            if (Math.abs(coord) < 1.0E-5) {
                return "0";
            }
            return gen.formatDouble5(coord);
        }

        private void paintStrokedGlyphs(PSGraphics2D g2d, TextUtil textUtil, Paint strokePaint, Stroke stroke) throws IOException {
            PSGenerator gen = textUtil.gen;
            PSTextPainter.this.applyColor(strokePaint, gen);
            PSGraphics2D.applyStroke(stroke, gen);
            Font f = null;
            Iterator iter = this.relativePositions.iterator();
            iter.next();
            Point2D.Double pos = new Point2D.Double(0.0, 0.0);
            gen.writeln("0 0 M");
            int c = this.currentChars.length();
            for (int i = 0; i < c; ++i) {
                boolean multiByte;
                char ch = this.currentChars.charAt(0);
                if (i == 0) {
                    f = textUtil.selectFontForChar(ch);
                }
                char mapped = f.mapChar(ch);
                if (i == 0) {
                    textUtil.selectFont(f, mapped);
                    textUtil.setCurrentFont(f, mapped);
                }
                mapped = f.mapChar(this.currentChars.charAt(i));
                FontMetrics metrics = f.getFontMetrics();
                boolean bl = multiByte = metrics instanceof MultiByteFont || metrics instanceof LazyFont && ((LazyFont)metrics).getRealFont() instanceof MultiByteFont;
                if (multiByte) {
                    gen.write("<");
                    gen.write(HexEncoder.encode(mapped));
                    gen.write(">");
                } else {
                    char codepoint = (char)(mapped % 256);
                    gen.write("(" + codepoint + ")");
                }
                gen.writeln(" false charpath");
                if (!iter.hasNext()) continue;
                Point2D pt = (Point2D)iter.next();
                ((Point2D)pos).setLocation(((Point2D)pos).getX() + pt.getX(), ((Point2D)pos).getY() - pt.getY());
                gen.writeln(gen.formatDouble5(((Point2D)pos).getX()) + " " + gen.formatDouble5(((Point2D)pos).getY()) + " M");
            }
            gen.writeln("stroke");
        }
    }

    private class TextUtil {
        private PSGenerator gen;
        private Font[] fonts;
        private Font currentFont;
        private int currentEncoding = -1;

        public TextUtil(PSGenerator gen) {
            this.gen = gen;
        }

        public boolean isMultiByte(Font f) {
            FontMetrics metrics = f.getFontMetrics();
            boolean multiByte = metrics instanceof MultiByteFont || metrics instanceof LazyFont && ((LazyFont)metrics).getRealFont() instanceof MultiByteFont;
            return multiByte;
        }

        public Font selectFontForChar(char ch) {
            int c = this.fonts.length;
            for (int i = 0; i < c; ++i) {
                if (!this.fonts[i].hasChar(ch)) continue;
                return this.fonts[i];
            }
            return this.fonts[0];
        }

        public void writeTextMatrix(AffineTransform transform) throws IOException {
            double[] matrix = new double[6];
            transform.getMatrix(matrix);
            this.gen.writeln(this.gen.formatDouble5(matrix[0]) + " " + this.gen.formatDouble5(matrix[1]) + " " + this.gen.formatDouble5(matrix[2]) + " " + this.gen.formatDouble5(matrix[3]) + " " + this.gen.formatDouble5(matrix[4]) + " " + this.gen.formatDouble5(matrix[5]) + " Tm");
        }

        public boolean isFontChanging(Font f, char mapped) {
            if (!this.isMultiByte(f)) {
                if (f != this.getCurrentFont()) {
                    return true;
                }
                if (mapped / 256 != this.getCurrentFontEncoding()) {
                    return true;
                }
            }
            return false;
        }

        public void selectFont(Font f, char mapped) throws IOException {
            int encoding = mapped / 256;
            String postfix = !this.isMultiByte(f) && encoding > 0 ? Integer.toString(encoding) : null;
            PSFontResource res = PSTextPainter.this.getResourceForFont(f, postfix);
            this.gen.useFont("/" + res.getName(), (float)f.getFontSize() / 1000.0f);
            res.notifyResourceUsageOnPage(this.gen.getResourceTracker());
        }

        public Font getCurrentFont() {
            return this.currentFont;
        }

        public int getCurrentFontEncoding() {
            return this.currentEncoding;
        }

        public void setCurrentFont(Font font, int encoding) {
            this.currentFont = font;
            this.currentEncoding = encoding;
        }

        public void setCurrentFont(Font font, char mapped) {
            int encoding = mapped / 256;
            this.setCurrentFont(font, encoding);
        }

        public void setupFonts(AttributedCharacterIterator runaci) {
            this.fonts = PSTextPainter.this.findFonts(runaci);
        }

        public boolean hasFonts() {
            return this.fonts != null && this.fonts.length > 0;
        }
    }
}

