/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.svg;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.SVGImageElementBridge;
import org.apache.batik.gvt.AbstractGraphicsNode;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.util.ParsedURL;
import org.apache.fop.image.loader.batik.BatikUtil;
import org.apache.fop.svg.AbstractFOPBridgeContext;
import org.apache.fop.svg.NativeImageHandler;
import org.apache.xmlgraphics.image.loader.Image;
import org.apache.xmlgraphics.image.loader.ImageException;
import org.apache.xmlgraphics.image.loader.ImageFlavor;
import org.apache.xmlgraphics.image.loader.ImageInfo;
import org.apache.xmlgraphics.image.loader.ImageManager;
import org.apache.xmlgraphics.image.loader.ImageSessionContext;
import org.apache.xmlgraphics.image.loader.impl.ImageGraphics2D;
import org.apache.xmlgraphics.image.loader.impl.ImageRawCCITTFax;
import org.apache.xmlgraphics.image.loader.impl.ImageRawJPEG;
import org.apache.xmlgraphics.image.loader.impl.ImageXMLDOM;
import org.apache.xmlgraphics.java2d.Graphics2DImagePainter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGDocument;

public abstract class AbstractFOPImageElementBridge
extends SVGImageElementBridge {
    protected GraphicsNode createImageGraphicsNode(BridgeContext ctx, Element imageElement, ParsedURL purl) {
        AbstractFOPBridgeContext bridgeCtx = (AbstractFOPBridgeContext)ctx;
        ImageManager manager = bridgeCtx.getImageManager();
        ImageSessionContext sessionContext = bridgeCtx.getImageSessionContext();
        try {
            ImageInfo info = manager.getImageInfo(purl.toString(), sessionContext);
            ImageFlavor[] supportedFlavors = this.getSupportedFlavours();
            Image image = manager.getImage(info, supportedFlavors, sessionContext);
            AbstractGraphicsNode specializedNode = null;
            if (image instanceof ImageXMLDOM) {
                ImageXMLDOM xmlImage = (ImageXMLDOM)image;
                if (xmlImage.getDocument() instanceof SVGDocument) {
                    SVGDocument clonedDoc = (SVGDocument)BatikUtil.cloneSVGDocument((Document)xmlImage.getDocument());
                    return this.createSVGImageNode(ctx, imageElement, clonedDoc);
                }
                image = manager.convertImage(xmlImage, new ImageFlavor[]{ImageFlavor.GRAPHICS2D});
            }
            if (image instanceof ImageRawJPEG) {
                specializedNode = this.createLoaderImageNode(image, ctx, imageElement, purl);
            } else if (image instanceof ImageRawCCITTFax) {
                specializedNode = this.createLoaderImageNode(image, ctx, imageElement, purl);
            } else if (image instanceof ImageGraphics2D) {
                ImageGraphics2D g2dImage = (ImageGraphics2D)image;
                specializedNode = new Graphics2DNode(g2dImage);
            } else {
                ctx.getUserAgent().displayError(new ImageException("Cannot convert an image to a usable format: " + purl));
            }
            if (specializedNode != null) {
                Rectangle2D imgBounds = AbstractFOPImageElementBridge.getImageBounds(ctx, imageElement);
                Rectangle2D bounds = specializedNode.getPrimitiveBounds();
                float[] vb = new float[]{0.0f, 0.0f, (float)bounds.getWidth(), (float)bounds.getHeight()};
                AbstractFOPImageElementBridge.initializeViewport(ctx, imageElement, specializedNode, vb, imgBounds);
                return specializedNode;
            }
        }
        catch (Exception e) {
            ctx.getUserAgent().displayError(e);
        }
        return this.superCreateGraphicsNode(ctx, imageElement, purl);
    }

    protected GraphicsNode superCreateGraphicsNode(BridgeContext ctx, Element imageElement, ParsedURL purl) {
        return super.createImageGraphicsNode(ctx, imageElement, purl);
    }

    protected abstract ImageFlavor[] getSupportedFlavours();

    protected LoaderImageNode createLoaderImageNode(Image image, BridgeContext ctx, Element imageElement, ParsedURL purl) {
        return new LoaderImageNode(image, ctx, imageElement, purl);
    }

    public static class Graphics2DNode
    extends AbstractGraphicsNode {
        private final ImageGraphics2D image;

        public Graphics2DNode(ImageGraphics2D g2d) {
            this.image = g2d;
        }

        public Shape getOutline() {
            return this.getPrimitiveBounds();
        }

        public void primitivePaint(Graphics2D g2d) {
            int width = this.image.getSize().getWidthPx();
            int height = this.image.getSize().getHeightPx();
            Rectangle2D.Double area = new Rectangle2D.Double(0.0, 0.0, width, height);
            Graphics2DImagePainter painter = this.image.getGraphics2DImagePainter();
            painter.paint(g2d, area);
        }

        public Rectangle2D getGeometryBounds() {
            return this.getPrimitiveBounds();
        }

        public Rectangle2D getPrimitiveBounds() {
            return new Rectangle2D.Double(0.0, 0.0, this.image.getSize().getWidthPx(), this.image.getSize().getHeightPx());
        }

        public Rectangle2D getSensitiveBounds() {
            return this.getPrimitiveBounds();
        }
    }

    public class LoaderImageNode
    extends AbstractGraphicsNode {
        protected final Image image;
        protected final BridgeContext ctx;
        protected final Element imageElement;
        protected final ParsedURL purl;
        protected GraphicsNode origGraphicsNode = null;

        public LoaderImageNode(Image image, BridgeContext ctx, Element imageElement, ParsedURL purl) {
            this.image = image;
            this.ctx = ctx;
            this.imageElement = imageElement;
            this.purl = purl;
        }

        public Shape getOutline() {
            return this.getPrimitiveBounds();
        }

        public void primitivePaint(Graphics2D g2d) {
            if (g2d instanceof NativeImageHandler) {
                NativeImageHandler nativeImageHandler = (NativeImageHandler)((Object)g2d);
                float x = 0.0f;
                float y = 0.0f;
                try {
                    float width = this.image.getSize().getWidthPx();
                    float height = this.image.getSize().getHeightPx();
                    nativeImageHandler.addNativeImage(this.image, x, y, width, height);
                }
                catch (Exception e) {
                    this.ctx.getUserAgent().displayError(e);
                }
            } else {
                if (this.origGraphicsNode == null) {
                    this.origGraphicsNode = AbstractFOPImageElementBridge.this.superCreateGraphicsNode(this.ctx, this.imageElement, this.purl);
                }
                this.origGraphicsNode.primitivePaint(g2d);
            }
        }

        public Rectangle2D getGeometryBounds() {
            return this.getPrimitiveBounds();
        }

        public Rectangle2D getPrimitiveBounds() {
            return new Rectangle2D.Double(0.0, 0.0, this.image.getSize().getWidthPx(), this.image.getSize().getHeightPx());
        }

        public Rectangle2D getSensitiveBounds() {
            return this.getPrimitiveBounds();
        }
    }
}

