/*
 * Decompiled with CFR 0.152.
 */
package rtf.app;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import rtf.BorderAttributes;
import rtf.app.ColorComboRenderer;

public class BorderControl
extends JPanel {
    public JComboBox colorCombo;
    public JCheckBox checkLeft = new JCheckBox("Left", true);
    public JCheckBox checkRight = new JCheckBox("Right", true);
    public JCheckBox checkTop = new JCheckBox("Top", true);
    public JCheckBox checkBottom = new JCheckBox("Bottom", true);
    public JCheckBox checkHorizontal = new JCheckBox("Horizontal", true);
    public JCheckBox checkVertical = new JCheckBox("Vertical", true);

    public BorderControl() {
        this.setBorder(new TitledBorder(new EtchedBorder(), "Borders:"));
        this.colorCombo = new JComboBox<Object>(new Object[]{Color.black, Color.red, Color.green, Color.blue, Color.white});
        this.colorCombo.setRenderer(new ColorComboRenderer());
        this.setLayout(new GridBagLayout());
        this.add((Component)new JLabel("Color"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 12, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.colorCombo, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 12, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.checkLeft, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 12, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.checkRight, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 12, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.checkTop, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 12, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.checkBottom, new GridBagConstraints(0, 4, 2, 1, 1.0, 0.0, 12, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.checkHorizontal, new GridBagConstraints(0, 5, 2, 1, 1.0, 0.0, 12, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.checkVertical, new GridBagConstraints(0, 6, 2, 1, 1.0, 0.0, 12, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public BorderControl(BorderAttributes ba) {
        this();
        this.setBorderAttributes(ba);
    }

    public void setBorderAttributes(BorderAttributes ba) {
        this.colorCombo.setSelectedItem(ba.lineColor);
        this.checkLeft.setSelected(ba.borderLeft != 0);
        this.checkRight.setSelected(ba.borderRight != 0);
        this.checkTop.setSelected(ba.borderTop != 0);
        this.checkBottom.setSelected(ba.borderBottom != 0);
        this.checkHorizontal.setSelected(ba.borderHorizontal != 0);
        this.checkVertical.setSelected(ba.borderVertical != 0);
    }

    public BorderAttributes getBorderAttributes() {
        BorderAttributes ba = new BorderAttributes();
        ba.setBorders(0);
        ba.lineColor = (Color)this.colorCombo.getSelectedItem();
        if (this.checkLeft.isSelected()) {
            ba.borderLeft = 1;
        }
        if (this.checkRight.isSelected()) {
            ba.borderRight = 1;
        }
        if (this.checkTop.isSelected()) {
            ba.borderTop = 1;
        }
        if (this.checkBottom.isSelected()) {
            ba.borderBottom = 1;
        }
        if (this.checkHorizontal.isSelected()) {
            ba.borderHorizontal = 1;
        }
        if (this.checkVertical.isSelected()) {
            ba.borderVertical = 1;
        }
        return ba;
    }
}

