/*
 * Decompiled with CFR 0.152.
 */
package rtf.app;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.MatteBorder;

public class ColorComboRenderer
extends JLabel
implements ListCellRenderer {
    protected Color m_color = Color.black;
    protected Color m_focusColor = (Color)UIManager.get("List.selectionBackground");
    protected Color m_nonFocusColor = Color.white;

    public ColorComboRenderer() {
        this.setOpaque(true);
    }

    public Component getListCellRendererComponent(JList list, Object obj, int row, boolean sel, boolean hasFocus) {
        if (hasFocus || sel) {
            this.setBorder(new CompoundBorder(new MatteBorder(2, 10, 2, 10, this.m_focusColor), new LineBorder(Color.black)));
        } else {
            this.setBorder(new CompoundBorder(new MatteBorder(2, 10, 2, 10, this.m_nonFocusColor), new LineBorder(Color.black)));
        }
        if (obj instanceof Color) {
            this.m_color = (Color)obj;
            this.setBackground(this.m_color);
            this.setText(" ");
        } else {
            this.setText(obj.toString());
            this.setBackground(Color.white);
            this.m_color = Color.white;
        }
        return this;
    }

    public void paintComponent(Graphics g) {
        this.setBackground(this.m_color);
        super.paintComponent(g);
    }
}

