/*
 * Decompiled with CFR 0.152.
 */
package rtf.app;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class DoubleSpinEdit
extends JPanel {
    protected JTextField m_textValue = new JTextField("0");
    protected double value = 0.0;
    protected double minValue = 0.0;
    protected double maxValue = 0.0;
    protected double step = 1.0;
    protected JButton m_bUp;
    protected JButton m_bDown;

    public DoubleSpinEdit(double min, double max) {
        this();
        this.setMaxValue(max);
        this.setMinValue(min);
    }

    public DoubleSpinEdit(double min, double max, double value) {
        this();
        this.setMaxValue(max);
        this.setMinValue(min);
        this.setValue(value);
    }

    public DoubleSpinEdit() {
        super(new BorderLayout());
        FocusListener lst_ = new FocusListener(){

            public void focusLost(FocusEvent e) {
                try {
                    double v = new Double(DoubleSpinEdit.this.m_textValue.getText());
                    if (v <= DoubleSpinEdit.this.maxValue && v >= DoubleSpinEdit.this.minValue && DoubleSpinEdit.this.minValue < DoubleSpinEdit.this.maxValue) {
                        DoubleSpinEdit.this.value = v;
                    } else if (v > DoubleSpinEdit.this.maxValue) {
                        DoubleSpinEdit.this.value = DoubleSpinEdit.this.maxValue;
                    } else if (v < DoubleSpinEdit.this.minValue) {
                        DoubleSpinEdit.this.value = DoubleSpinEdit.this.minValue;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                DoubleSpinEdit.this.draw();
            }

            public void focusGained(FocusEvent e) {
            }
        };
        this.m_textValue.addFocusListener(lst_);
        this.add((Component)this.m_textValue, "Center");
        JPanel p = new JPanel(new GridLayout(2, 1));
        this.m_bUp = new UpButton();
        this.m_bUp.setMargin(new Insets(0, 0, 0, 0));
        this.m_bUp.setPreferredSize(new Dimension(20, 5));
        ActionListener lst = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (DoubleSpinEdit.this.value + DoubleSpinEdit.this.step <= DoubleSpinEdit.this.maxValue && DoubleSpinEdit.this.value + DoubleSpinEdit.this.step >= DoubleSpinEdit.this.minValue && DoubleSpinEdit.this.minValue < DoubleSpinEdit.this.maxValue) {
                    DoubleSpinEdit.this.value += DoubleSpinEdit.this.step;
                    DoubleSpinEdit.this.draw();
                }
            }
        };
        this.m_bUp.addActionListener(lst);
        p.add(this.m_bUp);
        this.m_bDown = new DownButton();
        this.m_bDown.setMargin(new Insets(0, 0, 0, 0));
        this.m_bDown.setPreferredSize(new Dimension(20, 5));
        lst = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (DoubleSpinEdit.this.value - DoubleSpinEdit.this.step <= DoubleSpinEdit.this.maxValue && DoubleSpinEdit.this.value - DoubleSpinEdit.this.step >= DoubleSpinEdit.this.minValue && DoubleSpinEdit.this.minValue < DoubleSpinEdit.this.maxValue) {
                    DoubleSpinEdit.this.value -= DoubleSpinEdit.this.step;
                    DoubleSpinEdit.this.draw();
                }
            }
        };
        this.m_bDown.addActionListener(lst);
        p.add(this.m_bDown);
        this.add((Component)p, "East");
    }

    private void draw() {
        this.m_textValue.setText(Double.toString(this.value));
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double newValue) {
        this.value = newValue;
        this.draw();
    }

    public double getMinValue() {
        return this.minValue;
    }

    public void setMinValue(double newValue) {
        this.minValue = newValue;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(double newValue) {
        this.maxValue = newValue;
    }

    public double getStep() {
        return this.step;
    }

    public void setStep(double newValue) {
        this.step = newValue;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.m_textValue.setEnabled(enabled);
        this.m_bUp.setEnabled(enabled);
        this.m_bDown.setEnabled(enabled);
    }

    protected class DownButton
    extends JButton {
        protected DownButton() {
        }

        public void paint(Graphics g) {
            super.paint(g);
            Color old = g.getColor();
            g.setColor(Color.black);
            Rectangle clip = g.getClipBounds();
            int x = (int)(clip.getX() + clip.getWidth() / 2.0);
            int y = (int)(clip.getY() + clip.getHeight() / 2.0);
            g.fillPolygon(new int[]{x - 6, x + 5, x}, new int[]{y - 3, y - 3, y + 3}, 3);
            g.setColor(old);
        }
    }

    protected class UpButton
    extends JButton {
        protected UpButton() {
        }

        public void paint(Graphics g) {
            super.paint(g);
            Color old = g.getColor();
            g.setColor(Color.black);
            Rectangle clip = g.getClipBounds();
            int x = (int)(clip.getX() + clip.getWidth() / 2.0);
            int y = (int)(clip.getY() + clip.getHeight() / 2.0);
            g.fillPolygon(new int[]{x - 6, x + 5, x}, new int[]{y + 3, y + 3, y - 3}, 3);
            g.setColor(old);
        }
    }
}

