/*
 * Decompiled with CFR 0.152.
 */
package rtf.app;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.text.AttributeSet;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.StyledEditorKit;
import rtf.app.DoubleSpinEdit;
import rtf.app.Test;

public class ParagraphDialog
extends JDialog {
    protected int m_option = -1;
    protected MutableAttributeSet m_attributes;
    protected DoubleSpinEdit m_lineSpacing;
    protected DoubleSpinEdit m_spaceAbove;
    protected DoubleSpinEdit m_spaceBelow;
    protected DoubleSpinEdit m_firstIndent;
    protected DoubleSpinEdit m_leftIndent;
    protected DoubleSpinEdit m_rightIndent;
    protected JToggleButton m_btLeft;
    protected JToggleButton m_btCenter;
    protected JToggleButton m_btRight;
    protected JToggleButton m_btJustified;
    protected JEditorPane m_preview;

    public ParagraphDialog(JFrame parent) {
        super(parent, "Paragraph properties", true);
        this.setModal(true);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JPanel p = new JPanel(new GridLayout(1, 2, 5, 2));
        JPanel ps = new JPanel(new GridLayout(3, 2, 10, 2));
        ps.setBorder(new TitledBorder(new EtchedBorder(), "Space"));
        ps.add(new JLabel("Line spacing"));
        this.m_lineSpacing = new DoubleSpinEdit();
        this.m_lineSpacing.setMinValue(1.0);
        this.m_lineSpacing.setMaxValue(5.0);
        ps.add(this.m_lineSpacing);
        ps.add(new JLabel("Space above"));
        this.m_spaceAbove = new DoubleSpinEdit();
        this.m_spaceAbove.setMinValue(0.0);
        this.m_spaceAbove.setMaxValue(500.0);
        ps.add(this.m_spaceAbove);
        ps.add(new JLabel("Space below"));
        this.m_spaceBelow = new DoubleSpinEdit();
        this.m_spaceBelow.setMinValue(0.0);
        this.m_spaceBelow.setMaxValue(500.0);
        ps.add(this.m_spaceBelow);
        p.add(ps);
        JPanel pi = new JPanel(new GridLayout(3, 2, 10, 2));
        pi.setBorder(new TitledBorder(new EtchedBorder(), "Indent"));
        pi.add(new JLabel("First line indent"));
        this.m_firstIndent = new DoubleSpinEdit();
        this.m_firstIndent.setMinValue(-500.0);
        this.m_firstIndent.setMaxValue(500.0);
        pi.add(this.m_firstIndent);
        pi.add(new JLabel("Left indent"));
        this.m_leftIndent = new DoubleSpinEdit();
        this.m_leftIndent.setMinValue(0.0);
        this.m_leftIndent.setMaxValue(500.0);
        pi.add(this.m_leftIndent);
        pi.add(new JLabel("Right indent"));
        this.m_rightIndent = new DoubleSpinEdit();
        this.m_rightIndent.setMinValue(0.0);
        this.m_rightIndent.setMaxValue(500.0);
        pi.add(this.m_rightIndent);
        p.add(pi);
        this.getContentPane().add(p);
        p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(new JLabel("Alignment"));
        ButtonGroup bg = new ButtonGroup();
        this.m_btLeft = new JToggleButton("Left");
        bg.add(this.m_btLeft);
        p.add(this.m_btLeft);
        this.m_btCenter = new JToggleButton("Center");
        bg.add(this.m_btCenter);
        p.add(this.m_btCenter);
        this.m_btRight = new JToggleButton("Right");
        bg.add(this.m_btRight);
        p.add(this.m_btRight);
        this.m_btJustified = new JToggleButton("Justified");
        bg.add(this.m_btJustified);
        p.add(this.m_btJustified);
        this.getContentPane().add(p);
        p = new JPanel();
        p.setLayout(new BorderLayout());
        p.setBorder(new TitledBorder(new EtchedBorder(), "Preview"));
        this.m_preview = new JEditorPane();
        this.m_preview.setEditorKit(new StyledEditorKit());
        this.m_preview.setEnabled(false);
        this.m_preview.setText("Previous paragraph\nParagraph preview, paragraph preview, paragraph preview, paragraph preview\nNext paragraph");
        StyledDocument styled = (StyledDocument)this.m_preview.getDocument();
        SimpleAttributeSet attr = new SimpleAttributeSet();
        StyleConstants.setFontSize(attr, 6);
        styled.setCharacterAttributes(0, styled.getLength(), attr, false);
        JScrollPane scroll = new JScrollPane(this.m_preview);
        p.add((Component)scroll, "Center");
        this.getContentPane().add(p);
        p = new JPanel();
        JButton btOK = new JButton("Ok");
        ActionListener lst = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ParagraphDialog.this.m_option = 0;
                ((Component)ParagraphDialog.this).setVisible(false);
            }
        };
        btOK.addActionListener(lst);
        p.add(btOK);
        JButton btCancel = new JButton("Cancel");
        lst = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ParagraphDialog.this.m_option = 2;
                ((Component)ParagraphDialog.this).setVisible(false);
            }
        };
        btCancel.addActionListener(lst);
        p.add(btCancel);
        this.getContentPane().add(p);
        this.pack();
        Dimension d1 = this.getSize();
        Dimension d2 = parent.getSize();
        int x = Math.max((d2.width - d1.width) / 2, 0);
        int y = Math.max((d2.height - d1.height) / 2, 0);
        ((Component)this).setBounds(x, y, d1.width, d1.height + 50);
        FocusListener flst = new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                ParagraphDialog.this.updatePreview();
            }
        };
        this.m_lineSpacing.addFocusListener(flst);
        this.m_spaceAbove.addFocusListener(flst);
        this.m_spaceBelow.addFocusListener(flst);
        this.m_firstIndent.addFocusListener(flst);
        this.m_leftIndent.addFocusListener(flst);
        this.m_rightIndent.addFocusListener(flst);
        lst = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ParagraphDialog.this.updatePreview();
            }
        };
        this.m_btLeft.addActionListener(lst);
        this.m_btCenter.addActionListener(lst);
        this.m_btRight.addActionListener(lst);
        this.m_btJustified.addActionListener(lst);
    }

    public void setAttributes(AttributeSet a) {
        this.m_attributes = new SimpleAttributeSet(a);
        double value = StyleConstants.getLineSpacing(a);
        if (value < 1.0) {
            value = 1.0;
        }
        this.m_lineSpacing.setValue(value);
        float newValue = StyleConstants.getSpaceAbove(a);
        this.m_spaceAbove.setValue(Test.converPixelsToInches((int)newValue));
        newValue = StyleConstants.getSpaceBelow(a);
        this.m_spaceBelow.setValue(Test.converPixelsToInches((int)newValue));
        newValue = StyleConstants.getFirstLineIndent(a);
        this.m_firstIndent.setValue(Test.converPixelsToInches((int)newValue));
        newValue = StyleConstants.getLeftIndent(a);
        this.m_leftIndent.setValue(Test.converPixelsToInches((int)newValue));
        newValue = StyleConstants.getRightIndent(a);
        this.m_rightIndent.setValue(Test.converPixelsToInches((int)newValue));
        int alignment = StyleConstants.getAlignment(a);
        if (alignment == 0) {
            this.m_btLeft.setSelected(true);
        } else if (alignment == 1) {
            this.m_btCenter.setSelected(true);
        } else if (alignment == 2) {
            this.m_btRight.setSelected(true);
        } else if (alignment == 3) {
            this.m_btJustified.setSelected(true);
        }
        this.updatePreview();
    }

    public AttributeSet getAttributes() {
        if (this.m_attributes == null) {
            return null;
        }
        double newValue = this.m_lineSpacing.getValue();
        StyleConstants.setLineSpacing(this.m_attributes, (float)newValue);
        newValue = this.m_spaceAbove.getValue();
        StyleConstants.setSpaceAbove(this.m_attributes, Test.converInchesToPixels(newValue));
        newValue = this.m_spaceBelow.getValue();
        StyleConstants.setSpaceBelow(this.m_attributes, Test.converInchesToPixels(newValue));
        newValue = this.m_firstIndent.getValue();
        StyleConstants.setFirstLineIndent(this.m_attributes, Test.converInchesToPixels(newValue));
        newValue = this.m_leftIndent.getValue();
        StyleConstants.setLeftIndent(this.m_attributes, Test.converInchesToPixels(newValue));
        newValue = this.m_rightIndent.getValue();
        StyleConstants.setRightIndent(this.m_attributes, Test.converInchesToPixels(newValue));
        StyleConstants.setAlignment(this.m_attributes, this.getAlignment());
        return this.m_attributes;
    }

    public int getOption() {
        return this.m_option;
    }

    protected void updatePreview() {
        AttributeSet a = this.getAttributes();
        StyledDocument styled = (StyledDocument)this.m_preview.getDocument();
        styled.setParagraphAttributes(20, 0, a, false);
    }

    protected int getAlignment() {
        if (this.m_btLeft.isSelected()) {
            return 0;
        }
        if (this.m_btCenter.isSelected()) {
            return 1;
        }
        if (this.m_btRight.isSelected()) {
            return 2;
        }
        return 3;
    }
}

