/*
 * Decompiled with CFR 0.152.
 */
package rtf.app;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.text.Element;
import javax.swing.text.StyleConstants;
import rtf.AdvancedRTFDocument;
import rtf.BorderAttributes;
import rtf.app.BorderControl;
import rtf.app.DoubleSpinEdit;
import rtf.app.MarginsControl;

public class TableProperties
extends JDialog {
    BorderControl bc = new BorderControl();
    MarginsControl mc = new MarginsControl();
    DoubleSpinEdit widthSpin = new DoubleSpinEdit(10.0, 500.0);
    DoubleSpinEdit heightSpin = new DoubleSpinEdit(10.0, 500.0);
    AdvancedRTFDocument.TableElement table = null;
    AdvancedRTFDocument.RowElement row = null;
    AdvancedRTFDocument.CellElement cell = null;
    JToggleButton alignLeft = new JToggleButton("Left");
    JToggleButton alignCenter = new JToggleButton("Center");
    JToggleButton alignRight = new JToggleButton("Right");
    ButtonGroup group = new ButtonGroup();

    public TableProperties() {
        this.init();
    }

    protected void init() {
        this.getContentPane().setLayout(new GridBagLayout());
        JPanel pAlign = new JPanel();
        pAlign.setBorder(new TitledBorder(new EtchedBorder(), "Align:"));
        pAlign.add(this.alignLeft);
        pAlign.add(this.alignCenter);
        pAlign.add(this.alignRight);
        this.group.add(this.alignLeft);
        this.group.add(this.alignCenter);
        this.group.add(this.alignRight);
        this.getContentPane().add((Component)pAlign, new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 12, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.getContentPane().add((Component)this.bc, new GridBagConstraints(0, 1, 1, 3, 1.0, 0.0, 12, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.getContentPane().add((Component)new JLabel("Width:"), new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 12, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.getContentPane().add((Component)this.widthSpin, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 12, 1, new Insets(10, 0, 0, 0), 0, 0));
        this.getContentPane().add((Component)new JLabel("Height:"), new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 12, 0, new Insets(0, 0, 10, 0), 0, 0));
        this.getContentPane().add((Component)this.heightSpin, new GridBagConstraints(2, 2, 1, 1, 1.0, 0.0, 12, 1, new Insets(0, 0, 10, 0), 0, 0));
        this.getContentPane().add((Component)this.mc, new GridBagConstraints(1, 3, 2, 1, 1.0, 0.0, 12, 1, new Insets(0, 0, 0, 0), 0, 0));
        JPanel p = new JPanel(new GridLayout(1, 2));
        JButton bOk = new JButton("Ok");
        p.add(bOk);
        ActionListener lst = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TableProperties.this.apply();
                TableProperties.this.hide();
            }
        };
        bOk.addActionListener(lst);
        JButton bCancel = new JButton("Cancel");
        p.add(bCancel);
        lst = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TableProperties.this.hide();
            }
        };
        bCancel.addActionListener(lst);
        this.getContentPane().add((Component)p, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 12, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.getContentPane().add((Component)new JLabel(""), new GridBagConstraints(2, 5, 1, 1, 0.0, 1.0, 12, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.pack();
    }

    public void setTable(Element el) {
        this.setTitle("Table properties");
        this.table = (AdvancedRTFDocument.TableElement)el;
        this.widthSpin.setValue(this.table.getWidth());
        this.widthSpin.setEnabled(false);
        this.heightSpin.setValue(this.table.getHeight());
        this.heightSpin.setEnabled(false);
        BorderAttributes ba = (BorderAttributes)this.table.getAttribute("BorderAttributes");
        this.bc.setBorderAttributes(ba);
        this.alignLeft.setEnabled(true);
        this.alignRight.setEnabled(true);
        this.alignCenter.setEnabled(true);
        int align = StyleConstants.getAlignment(this.table.getAttributes());
        switch (align) {
            case 0: {
                this.alignLeft.setSelected(true);
                break;
            }
            case 2: {
                this.alignRight.setSelected(true);
                break;
            }
            case 1: {
                this.alignCenter.setSelected(true);
            }
        }
    }

    public void setRow(Element el) {
        this.setTitle("Row properties");
        this.row = (AdvancedRTFDocument.RowElement)el;
        this.widthSpin.setValue(this.row.getWidth());
        this.widthSpin.setEnabled(false);
        this.heightSpin.setValue(this.row.getHeight());
        this.heightSpin.setEnabled(true);
        BorderAttributes ba = (BorderAttributes)this.row.getAttribute("BorderAttributes");
        this.bc.setBorderAttributes(ba);
        this.alignLeft.setEnabled(false);
        this.alignRight.setEnabled(false);
        this.alignCenter.setEnabled(false);
    }

    public void setCell(Element el) {
        this.setTitle("Cell properties");
        this.cell = (AdvancedRTFDocument.CellElement)el;
        this.widthSpin.setValue(this.cell.getWidth());
        this.widthSpin.setEnabled(true);
        this.heightSpin.setValue(this.cell.getHeight());
        this.heightSpin.setEnabled(true);
        BorderAttributes ba = (BorderAttributes)this.cell.getAttribute("BorderAttributes");
        this.bc.setBorderAttributes(ba);
        this.mc.setMargins(this.cell.getMargins());
        this.alignLeft.setEnabled(false);
        this.alignRight.setEnabled(false);
        this.alignCenter.setEnabled(false);
    }

    public BorderAttributes getBorderAttributes() {
        return this.bc.getBorderAttributes();
    }

    protected void apply() {
        if (this.table != null) {
            int align = 0;
            if (this.alignRight.isSelected()) {
                align = 2;
            }
            if (this.alignCenter.isSelected()) {
                align = 1;
            }
            this.table.setAlignment(align);
            this.table.setMargins(this.mc.getMargins());
            this.table.setBorders(this.getBorderAttributes());
        }
        if (this.row != null) {
            this.row.setMargins(this.mc.getMargins());
            this.row.setHeight((int)this.heightSpin.getValue());
            this.row.setBorders(this.getBorderAttributes());
        }
        if (this.cell != null) {
            this.cell.setMargins(this.mc.getMargins());
            this.cell.setHeight((int)this.heightSpin.getValue());
            this.cell.setWidth((int)this.widthSpin.getValue());
            this.cell.setBorders(this.getBorderAttributes());
        }
    }
}

