/*
 * Decompiled with CFR 0.152.
 */
package rtf.app;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.io.FileInputStream;
import java.io.FileWriter;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.tree.TreeNode;
import rtf.AdvancedRTFDocument;
import rtf.AdvancedRTFEditorKit;
import rtf.BorderAttributes;
import rtf.app.InsertTableDialog;
import rtf.app.MarginsDialog;
import rtf.app.ParagraphDialog;
import rtf.app.TableProperties;

public class Test {
    private JFrame mainFrame = new JFrame("RTFEditorKit test");
    private JTextPane edit;
    private JMenuBar mainMenu;
    private JSplitPane split;
    private JTree tree;
    private JCheckBoxMenuItem splittingMenuItem;

    public Test() {
        this.mainFrame.setDefaultCloseOperation(3);
        this.mainFrame.getContentPane().setLayout(new BorderLayout());
        this.initMenuBar();
        this.mainFrame.setJMenuBar(this.mainMenu);
        this.edit = new JTextPane();
        this.edit.setEditorKit(new AdvancedRTFEditorKit());
        this.showFeatures();
        JScrollPane scrollEdit = new JScrollPane(this.edit);
        this.tree = new JTree((TreeNode)((Object)this.edit.getDocument().getDefaultRootElement()));
        JScrollPane scrollTree = new JScrollPane(this.tree);
        this.split = new JSplitPane(1, scrollEdit, scrollTree);
        this.split.setDividerLocation(520);
        this.mainFrame.getContentPane().add((Component)this.split, "Center");
        ((Component)this.mainFrame).setSize(new Dimension(820, 450));
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (d.width - this.mainFrame.getWidth()) / 2;
        int y = (d.height - this.mainFrame.getHeight()) / 2;
        ((Component)this.mainFrame).setBounds(x, y, this.mainFrame.getWidth(), this.mainFrame.getHeight());
        this.mainFrame.show();
    }

    protected void initMenuBar() {
        this.mainMenu = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        this.mainMenu.add(fileMenu);
        fileMenu.add(new JMenuItem(this.saveAction()));
        fileMenu.add(new JMenuItem(this.loadAction()));
        JMenu editMenu = new JMenu("Edit");
        this.mainMenu.add(editMenu);
        editMenu.add(new JMenuItem(this.copyAction()));
        editMenu.add(new JMenuItem(this.pasteAction()));
        editMenu.addSeparator();
        editMenu.add(new JMenuItem(this.insertImageAction()));
        editMenu.add(new JMenuItem(this.paragraphAttributesAction()));
        editMenu.add(new JMenuItem(this.setMarginsAction()));
        editMenu.add(new JMenuItem(this.documentWidthAction()));
        JMenu tableMenu = new JMenu("Table");
        JMenu insert = new JMenu("Insert");
        insert.add(new JMenuItem(this.insertTableAction()));
        insert.addSeparator();
        insert.add(new JMenuItem(this.insertRowAction(true)));
        insert.add(new JMenuItem(this.insertRowAction(false)));
        insert.addSeparator();
        insert.add(new JMenuItem(this.insertColumnAction(true)));
        insert.add(new JMenuItem(this.insertColumnAction(false)));
        tableMenu.add(insert);
        JMenu delete = new JMenu("Delete");
        delete.add(new JMenuItem(this.deleteTableAction()));
        delete.add(new JMenuItem(this.deleteRowAction()));
        delete.add(new JMenuItem(this.deleteColumnAction()));
        tableMenu.add(delete);
        this.mainMenu.add(tableMenu);
        JMenu properties = new JMenu("Properties");
        properties.add(new JMenuItem(this.tablePropertiesAction()));
        properties.add(new JMenuItem(this.rowPropertiesAction()));
        properties.add(new JMenuItem(this.cellPropertiesAction()));
        this.mainMenu.add(properties);
    }

    protected Action insertImageAction() {
        AbstractAction a = new AbstractAction("Insert image"){

            public void actionPerformed(ActionEvent e) {
                JFileChooser fc = new JFileChooser();
                if (fc.showOpenDialog(Test.this.mainFrame) != 0) {
                    return;
                }
                ImageIcon icon = new ImageIcon(fc.getSelectedFile().getPath());
                int w = icon.getIconWidth();
                int h = icon.getIconHeight();
                if (w <= 0 || h <= 0) {
                    JOptionPane.showMessageDialog(Test.this.mainFrame, "Invalid image!");
                    return;
                }
                AdvancedRTFDocument doc = (AdvancedRTFDocument)Test.this.edit.getDocument();
                doc.insertPicture(icon, Test.this.edit.getCaretPosition());
            }
        };
        return a;
    }

    protected Action paragraphAttributesAction() {
        AbstractAction a = new AbstractAction("Paragraph..."){

            public void actionPerformed(ActionEvent e) {
                ParagraphDialog pd = new ParagraphDialog(Test.this.mainFrame);
                AttributeSet attrs = ((AdvancedRTFDocument)Test.this.edit.getDocument()).getParagraphElement(Test.this.edit.getCaretPosition()).getAttributes();
                pd.setAttributes(attrs);
                pd.show();
                if (pd.getOption() == 0) {
                    AdvancedRTFDocument doc = (AdvancedRTFDocument)Test.this.edit.getDocument();
                    AttributeSet attr = pd.getAttributes();
                    doc.setParagraphAttributes(Test.this.edit.getSelectionStart(), Test.this.edit.getSelectionEnd() - Test.this.edit.getSelectionStart(), attr, false);
                }
            }
        };
        return a;
    }

    protected Action insertTableAction() {
        AbstractAction a = new AbstractAction("Table..."){

            public void actionPerformed(ActionEvent e) {
                InsertTableDialog dlg = new InsertTableDialog(Test.this.mainFrame);
                dlg.show();
                if (dlg.getOption() == 0) {
                    int i;
                    int pos = Test.this.edit.getCaretPosition();
                    AdvancedRTFDocument doc = (AdvancedRTFDocument)Test.this.edit.getDocument();
                    Element cell = doc.getCell(pos);
                    SimpleAttributeSet attrs = new SimpleAttributeSet();
                    BorderAttributes ba = new BorderAttributes();
                    ba.setBorders(63);
                    ba.lineColor = dlg.getColor();
                    attrs.addAttribute("BorderAttributes", ba);
                    int[] widths = new int[dlg.getColumnCount()];
                    if (cell == null) {
                        for (int i2 = 0; i2 < widths.length; ++i2) {
                            widths[i2] = 100;
                        }
                    } else {
                        int width = ((AdvancedRTFDocument.CellElement)cell).getWidth() - 4;
                        for (i = 0; i < widths.length; ++i) {
                            widths[i] = width / dlg.getColumnCount();
                        }
                    }
                    int[] heights = new int[dlg.getRowCount()];
                    for (i = 0; i < heights.length; ++i) {
                        heights[i] = 1;
                    }
                    doc.insertTable(pos, dlg.getRowCount(), dlg.getColumnCount(), attrs, widths, heights);
                }
            }
        };
        return a;
    }

    protected Action insertRowAction(final boolean above) {
        String label = "Row";
        label = above ? label + " above" : label + " below";
        AbstractAction a = new AbstractAction(label){

            public void actionPerformed(ActionEvent e) {
                AdvancedRTFDocument doc = (AdvancedRTFDocument)Test.this.edit.getDocument();
                doc.insertRow(Test.this.edit.getCaretPosition(), above);
            }
        };
        return a;
    }

    protected Action insertColumnAction(final boolean before) {
        String label = "Column";
        label = before ? label + " to the left" : label + " to the right";
        AbstractAction a = new AbstractAction(label){

            public void actionPerformed(ActionEvent e) {
                AdvancedRTFDocument doc = (AdvancedRTFDocument)Test.this.edit.getDocument();
                doc.insertColumn(Test.this.edit.getCaretPosition(), 50, before);
            }
        };
        return a;
    }

    protected Action deleteTableAction() {
        AbstractAction a = new AbstractAction("Table"){

            public void actionPerformed(ActionEvent e) {
                AdvancedRTFDocument doc = (AdvancedRTFDocument)Test.this.edit.getDocument();
                doc.deleteTable(Test.this.edit.getCaretPosition());
            }
        };
        return a;
    }

    protected Action deleteRowAction() {
        AbstractAction a = new AbstractAction("Row"){

            public void actionPerformed(ActionEvent e) {
                AdvancedRTFDocument doc = (AdvancedRTFDocument)Test.this.edit.getDocument();
                doc.deleteRow(Test.this.edit.getCaretPosition());
            }
        };
        return a;
    }

    protected Action deleteColumnAction() {
        AbstractAction a = new AbstractAction("Column"){

            public void actionPerformed(ActionEvent e) {
                AdvancedRTFDocument doc = (AdvancedRTFDocument)Test.this.edit.getDocument();
                doc.deleteColumn(Test.this.edit.getCaretPosition());
            }
        };
        return a;
    }

    protected Action setMarginsAction() {
        AbstractAction a = new AbstractAction("Margins..."){

            public void actionPerformed(ActionEvent e) {
                AdvancedRTFDocument doc = (AdvancedRTFDocument)Test.this.edit.getDocument();
                MarginsDialog dlg = new MarginsDialog(Test.this.mainFrame);
                dlg.setMargins(doc.getDocumentMargins());
                dlg.show();
                if (dlg.getOption() == 0) {
                    doc.setDocumentMargins(dlg.getMargins());
                }
            }
        };
        return a;
    }

    protected Action saveAction() {
        AbstractAction a = new AbstractAction("Save..."){

            public void actionPerformed(ActionEvent e) {
                JFileChooser fc = new JFileChooser();
                if (fc.showSaveDialog(Test.this.mainFrame) != 0) {
                    return;
                }
                String filePath = fc.getSelectedFile().getPath();
                try {
                    FileWriter writer = new FileWriter(filePath);
                    Test.this.edit.getEditorKit().write(writer, Test.this.edit.getDocument(), 0, Test.this.edit.getDocument().getLength());
                    writer.flush();
                    writer.close();
                }
                catch (Exception ex) {
                    System.err.println(ex.getMessage());
                    JOptionPane.showMessageDialog(null, ex.getMessage(), "Writing error!", 0);
                }
            }
        };
        return a;
    }

    protected Action loadAction() {
        AbstractAction a = new AbstractAction("Load..."){

            public void actionPerformed(ActionEvent e) {
                JFileChooser fc = new JFileChooser();
                if (fc.showOpenDialog(Test.this.mainFrame) != 0) {
                    return;
                }
                String filePath = fc.getSelectedFile().getPath();
                try {
                    FileInputStream in = new FileInputStream(filePath);
                    Test.this.edit.setEditorKit(new AdvancedRTFEditorKit());
                    Test.this.edit.getEditorKit().read(in, Test.this.edit.getDocument(), 0);
                    in.close();
                }
                catch (Exception ex) {
                    System.err.println(ex.getMessage());
                    JOptionPane.showMessageDialog(null, ex.getMessage(), "Writing error!", 0);
                }
                Test.this.showHF();
            }
        };
        return a;
    }

    private void showHF() {
        JEditorPane pane;
        JFrame frame;
        AdvancedRTFDocument headerDoc = (AdvancedRTFDocument)this.edit.getDocument().getProperty("first_page_header");
        if (headerDoc != null) {
            frame = new JFrame("First page header");
            frame.setDefaultCloseOperation(3);
            pane = new JEditorPane();
            pane.setEditorKit(new AdvancedRTFEditorKit());
            pane.setDocument(headerDoc);
            frame.getContentPane().add(new JScrollPane(pane));
            ((Component)frame).setBounds(0, 0, 200, 100);
            ((Component)frame).setVisible(true);
        }
        if ((headerDoc = (AdvancedRTFDocument)this.edit.getDocument().getProperty("even_page_header")) != null) {
            frame = new JFrame("Even page header");
            frame.setDefaultCloseOperation(3);
            pane = new JEditorPane();
            pane.setEditorKit(new AdvancedRTFEditorKit());
            pane.setDocument(headerDoc);
            frame.getContentPane().add(new JScrollPane(pane));
            ((Component)frame).setBounds(10, 10, 200, 100);
            ((Component)frame).setVisible(true);
        }
        if ((headerDoc = (AdvancedRTFDocument)this.edit.getDocument().getProperty("odd_page_header")) != null) {
            frame = new JFrame("Odd page header");
            frame.setDefaultCloseOperation(3);
            pane = new JEditorPane();
            pane.setEditorKit(new AdvancedRTFEditorKit());
            pane.setDocument(headerDoc);
            frame.getContentPane().add(new JScrollPane(pane));
            ((Component)frame).setBounds(20, 20, 200, 100);
            ((Component)frame).setVisible(true);
        }
        if ((headerDoc = (AdvancedRTFDocument)this.edit.getDocument().getProperty("first_page_footer")) != null) {
            frame = new JFrame("First page footer");
            frame.setDefaultCloseOperation(3);
            pane = new JEditorPane();
            pane.setEditorKit(new AdvancedRTFEditorKit());
            pane.setDocument(headerDoc);
            frame.getContentPane().add(new JScrollPane(pane));
            ((Component)frame).setBounds(30, 30, 200, 100);
            ((Component)frame).setVisible(true);
        }
        if ((headerDoc = (AdvancedRTFDocument)this.edit.getDocument().getProperty("even_page_footer")) != null) {
            frame = new JFrame("Even page footer");
            frame.setDefaultCloseOperation(3);
            pane = new JEditorPane();
            pane.setEditorKit(new AdvancedRTFEditorKit());
            pane.setDocument(headerDoc);
            frame.getContentPane().add(new JScrollPane(pane));
            ((Component)frame).setBounds(40, 40, 200, 100);
            ((Component)frame).setVisible(true);
        }
        if ((headerDoc = (AdvancedRTFDocument)this.edit.getDocument().getProperty("odd_page_footer")) != null) {
            frame = new JFrame("Odd page footer");
            frame.setDefaultCloseOperation(3);
            pane = new JEditorPane();
            pane.setEditorKit(new AdvancedRTFEditorKit());
            pane.setDocument(headerDoc);
            frame.getContentPane().add(new JScrollPane(pane));
            ((Component)frame).setBounds(50, 50, 200, 100);
            ((Component)frame).setVisible(true);
        }
        if ((headerDoc = (AdvancedRTFDocument)this.edit.getDocument().getProperty("common_header")) != null) {
            frame = new JFrame("Common header");
            frame.setDefaultCloseOperation(3);
            pane = new JEditorPane();
            pane.setEditorKit(new AdvancedRTFEditorKit());
            pane.setDocument(headerDoc);
            frame.getContentPane().add(new JScrollPane(pane));
            ((Component)frame).setBounds(60, 60, 200, 100);
            ((Component)frame).setVisible(true);
        }
        if ((headerDoc = (AdvancedRTFDocument)this.edit.getDocument().getProperty("common_footer")) != null) {
            frame = new JFrame("Common footer");
            frame.setDefaultCloseOperation(3);
            pane = new JEditorPane();
            pane.setEditorKit(new AdvancedRTFEditorKit());
            pane.setDocument(headerDoc);
            frame.getContentPane().add(new JScrollPane(pane));
            ((Component)frame).setBounds(70, 70, 200, 100);
            ((Component)frame).setVisible(true);
        }
    }

    protected Action copyAction() {
        AbstractAction a = new AbstractAction("Copy CTRL+C"){

            public void actionPerformed(ActionEvent e) {
                Test.this.edit.copy();
            }
        };
        return a;
    }

    protected Action pasteAction() {
        AbstractAction a = new AbstractAction("Paste CTRL+V"){

            public void actionPerformed(ActionEvent e) {
                Test.this.edit.paste();
            }
        };
        return a;
    }

    public static void main(String[] args) {
        new Test();
    }

    public void showFeaturesTest() {
        AdvancedRTFDocument doc = (AdvancedRTFDocument)this.edit.getDocument();
        try {
            SimpleAttributeSet attrs = new SimpleAttributeSet();
            StyleConstants.setFontSize(attrs, 16);
            StyleConstants.setForeground(attrs, Color.red);
            doc.insertString(0, "333", attrs);
            attrs = new SimpleAttributeSet();
            StyleConstants.setFontSize(attrs, 16);
            StyleConstants.setForeground(attrs, Color.blue);
            doc.insertString(0, "222", attrs);
            attrs = new SimpleAttributeSet();
            StyleConstants.setFontSize(attrs, 16);
            StyleConstants.setForeground(attrs, Color.yellow);
            doc.insertString(0, "111", attrs);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void showFeatures() {
        AdvancedRTFDocument doc = (AdvancedRTFDocument)this.edit.getDocument();
        try {
            doc.setDocumentMargins(new Insets(50, 50, 50, 50));
            String paragraph = "Usual paragraph text ";
            for (int i = 0; i < 4; ++i) {
                paragraph = paragraph + paragraph;
            }
            doc.insertString(0, paragraph + "\n ", null);
            paragraph = "Show paragraph features support. Alignment justified, first line ident is 50, line spacing is 1.5. ";
            paragraph = paragraph + paragraph;
            SimpleAttributeSet attrs = new SimpleAttributeSet();
            StyleConstants.setAlignment(attrs, 3);
            StyleConstants.setFirstLineIndent(attrs, 50.0f);
            StyleConstants.setLineSpacing(attrs, 1.5f);
            StyleConstants.setLeftIndent(attrs, 10.0f);
            StyleConstants.setRightIndent(attrs, 10.0f);
            doc.insertString(0, paragraph + "\n", null);
            doc.setParagraphAttributes(0, paragraph.length(), attrs, false);
            doc.insertString(0, "\n", null);
            doc.setParagraphAttributes(0, 1, new SimpleAttributeSet(), true);
            BorderAttributes ba = new BorderAttributes();
            ba.setBorders(63);
            ba.lineColor = Color.black;
            int[] widths = new int[]{150, 100, 50};
            int[] heights = new int[]{1, 50};
            attrs = new SimpleAttributeSet();
            attrs.addAttribute("BorderAttributes", ba);
            doc.insertTable(1, 2, 3, attrs, widths, heights);
            doc.insertString(2, "Tables support", null);
            ba = new BorderAttributes();
            ba.setBorders(63);
            ba.lineColor = Color.blue;
            widths = new int[]{70, 50};
            heights = new int[]{1, 50, 1};
            attrs = new SimpleAttributeSet();
            attrs.addAttribute("BorderAttributes", ba);
            StyleConstants.setAlignment(attrs, 2);
            doc.insertTable(1, 3, 2, attrs, widths, heights);
            doc.insertString(1, "Nested tables support", null);
            BufferedImage bi = new BufferedImage(100, 50, 1);
            Graphics g = bi.getGraphics();
            Color old = g.getColor();
            g.setColor(Color.yellow);
            g.fillRect(0, 0, 100, 50);
            g.setColor(Color.blue);
            g.fillOval(15, 15, 70, 30);
            g.setFont(new Font("Arial", 1, 16));
            g.setColor(Color.red);
            g.drawString("Image test", 10, 10);
            g.setColor(old);
            doc.insertPicture(new ImageIcon(bi), doc.getLength() - 1);
            SimpleAttributeSet attrss = new SimpleAttributeSet();
            StyleConstants.setFontSize(attrss, 14);
            StyleConstants.setItalic(attrss, true);
            doc.insertString(0, "1111111111111111111\n2222222222222222222\n3333333333333333333", attrss);
            attrs = new SimpleAttributeSet();
            StyleConstants.setFontFamily(attrs, "Arial");
            doc.setCharacterAttributes(0, 20, attrs, false);
            StyleConstants.setFontFamily(attrs, "Serif");
            doc.setCharacterAttributes(20, 20, attrs, false);
            attrs = new SimpleAttributeSet();
            StyleConstants.setAlignment(attrs, 2);
            doc.setParagraphAttributes(0, 60, attrs, false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static double converPixelsToInches(int pixSize) {
        int factor = (int)Math.pow(10.0, 5.0);
        double result = (double)Math.round((double)pixSize / 72.0 * (double)factor) / (double)factor;
        return result;
    }

    public static int converInchesToPixels(double inchSize) {
        return (int)Math.round(inchSize * 72.0);
    }

    protected Action tablePropertiesAction() {
        AbstractAction a = new AbstractAction("Table..."){

            public void actionPerformed(ActionEvent e) {
                AdvancedRTFDocument doc = (AdvancedRTFDocument)Test.this.edit.getDocument();
                Element table = doc.getTable(Test.this.edit.getCaretPosition());
                if (table == null) {
                    JOptionPane.showMessageDialog(null, "Invalid table offset!");
                    return;
                }
                TableProperties tp = new TableProperties();
                tp.setTable(table);
                tp.show();
            }
        };
        return a;
    }

    protected Action rowPropertiesAction() {
        AbstractAction a = new AbstractAction("Row..."){

            public void actionPerformed(ActionEvent e) {
                AdvancedRTFDocument doc = (AdvancedRTFDocument)Test.this.edit.getDocument();
                Element row = doc.getRow(Test.this.edit.getCaretPosition());
                if (row == null) {
                    JOptionPane.showMessageDialog(null, "Invalid row offset!");
                    return;
                }
                TableProperties tp = new TableProperties();
                tp.setRow(row);
                tp.show();
            }
        };
        return a;
    }

    protected Action cellPropertiesAction() {
        AbstractAction a = new AbstractAction("Cell..."){

            public void actionPerformed(ActionEvent e) {
                AdvancedRTFDocument doc = (AdvancedRTFDocument)Test.this.edit.getDocument();
                Element cell = doc.getCell(Test.this.edit.getCaretPosition());
                if (cell == null) {
                    JOptionPane.showMessageDialog(null, "Invalid cell offset!");
                    return;
                }
                TableProperties tp = new TableProperties();
                tp.setCell(cell);
                tp.show();
            }
        };
        return a;
    }

    protected Action documentWidthAction() {
        AbstractAction a = new AbstractAction("Document width"){

            public void actionPerformed(ActionEvent e) {
                AdvancedRTFDocument doc = (AdvancedRTFDocument)Test.this.edit.getDocument();
                int width = doc.DOCUMENT_WIDTH;
                String sWidth = JOptionPane.showInputDialog("Input new document width.", (Object)Integer.toString(width));
                try {
                    width = new Integer(sWidth);
                }
                catch (Exception ex) {
                    width = 0;
                }
                doc.DOCUMENT_WIDTH = width;
                doc.refresh();
            }
        };
        return a;
    }
}

