/*
 * Decompiled with CFR 0.152.
 */
package rtf.reader;

import java.awt.Color;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import rtf.AdvancedRTFDocument;
import rtf.BorderAttributes;
import rtf.reader.RtfNode;
import rtf.reader.RtfParser;

public class RTFReader {
    protected AdvancedRTFDocument mainDocument;
    private Hashtable fontMap = new Hashtable();
    private Vector colorTable = new Vector(1000);
    private int currentOffset = 0;

    public RTFReader(Document doc) {
        this.mainDocument = (AdvancedRTFDocument)doc;
        this.colorTable.add(Color.black);
    }

    public void read(String fileName, int offset) throws IOException, BadLocationException {
        FileReader in = new FileReader(fileName);
        this.read(in, offset);
        in.close();
    }

    public void read(Reader in, int offset) throws IOException, BadLocationException {
        try {
            this.currentOffset = offset;
            RtfParser rtf = new RtfParser(in);
            RtfNode root = null;
            try {
                root = rtf.parse();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new IOException(ex.getMessage());
            }
            if (root == null) {
                return;
            }
            int cnt = root.getChildCount();
            for (int i = 0; i < cnt; ++i) {
                RtfNode node = root.getChild(i);
                String nodeName = node.getName();
                Object nodeContent = node.getContent();
                String nodeType = node.getType();
                int nodeLength = node.getLength();
                if (nodeName.equals("\\pard") || nodeName.equals("\\li") || nodeName.equals("\\ri") || nodeName.equals("\\fi") || nodeName.equals("\\f") || nodeName.equals("\\fs")) {
                    this.currentOffset = offset;
                    this.processDocumentBody(root, i, this.mainDocument);
                    if (this.mainDocument.getText(0, this.mainDocument.getLength()).charAt(this.currentOffset - 1) == '\n') {
                        this.mainDocument.remove(this.currentOffset - 1, 1);
                    }
                    break;
                }
                if (!nodeName.equals("*<group>*")) continue;
                RtfNode groupNode = node;
                String groupName = groupNode.getChild(0).getName();
                this.processGroup(groupNode, groupName);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println("Invalid RTF content! " + ex.getMessage());
        }
    }

    private void processDocumentBody(RtfNode root, int indexStartBody, AdvancedRTFDocument document) throws BadLocationException, IOException {
        SimpleAttributeSet attr = new SimpleAttributeSet();
        int cnt = root.getChildCount();
        String previousName = "";
        for (int i = indexStartBody; i < cnt; ++i) {
            RtfNode node = root.getChild(i);
            String nodeName = node.getName();
            Object nodeContent = node.getContent();
            if (nodeName.equals("\\pard")) {
                attr = attr == null ? new SimpleAttributeSet() : new SimpleAttributeSet();
            } else if (nodeName.equals("*<group>*")) {
                this.processBodyGroup(node, attr, document);
            } else if (nodeName.equals("\\tab")) {
                document.insertString(this.currentOffset, "\t", attr);
                ++this.currentOffset;
                nodeContent = null;
            } else if (nodeName.equals("\\page")) {
                if (!document.getText(this.currentOffset - 1, 1).equals("\n")) {
                    document.insertString(this.currentOffset, "\n\f\n", attr);
                    this.currentOffset += 3;
                } else {
                    document.insertString(this.currentOffset, "\f", attr);
                    ++this.currentOffset;
                }
                nodeContent = null;
            } else if (nodeName.equals("\\par")) {
                document.insertString(this.currentOffset, "\n", attr);
                this.removeCharacterAttributes(attr);
                document.setParagraphAttributes(this.currentOffset, 0, attr, false);
                ++this.currentOffset;
                nodeContent = null;
            } else if (nodeName.equals("\\intbl")) {
                int endOfTableInd = this.processTableDefinition(node, attr, i, 1, document);
                this.processTableContent(node, attr, i, endOfTableInd, 1, document);
                i = endOfTableInd;
            } else if (nodeName.substring(0, Math.min(2, nodeName.length())).equals("\\'")) {
                if (node.getLength() != -1) {
                    String ll = nodeName.substring(2, 4);
                    byte b1 = Byte.parseByte(ll.substring(0, 1), 16);
                    byte b2 = Byte.parseByte(ll.substring(1, 2), 16);
                    byte value = (byte)(b1 * 16 + b2);
                    char ch = new Character((char)value).charValue();
                    byte[] bb = new byte[]{value};
                    String ss = new String(bb);
                    document.insertString(this.currentOffset, ss, attr);
                    ++this.currentOffset;
                    if (ll.length() > 2) {
                        ss = ll.substring(2);
                        document.insertString(this.currentOffset, ss, attr);
                        this.currentOffset += ss.length();
                    }
                }
            } else {
                this.processAttribute(node, attr);
            }
            if (nodeContent != null) {
                String content = (String)nodeContent;
                if (i != 0 && !previousName.equals("*<group>*") && content.charAt(0) == ' ') {
                    document.insertString(this.currentOffset, content.substring(1), attr);
                    this.currentOffset += content.length() - 1;
                } else {
                    document.insertString(this.currentOffset, content, attr);
                    this.currentOffset += content.length();
                }
            }
            previousName = nodeName;
        }
    }

    private void processAttribute(RtfNode node, MutableAttributeSet attr) {
        String name = node.getName();
        if (name.equals("\\ql")) {
            StyleConstants.setAlignment(attr, 0);
        } else if (name.equals("\\qr")) {
            StyleConstants.setAlignment(attr, 2);
        } else if (name.equals("\\qc")) {
            StyleConstants.setAlignment(attr, 1);
        } else if (name.equals("\\qj")) {
            StyleConstants.setAlignment(attr, 3);
        } else if (name.equals("\\b")) {
            if (node.getLength() == -1) {
                StyleConstants.setBold(attr, true);
            } else {
                StyleConstants.setBold(attr, false);
            }
        } else if (name.equals("\\i")) {
            if (node.getLength() == -1) {
                StyleConstants.setItalic(attr, true);
            } else {
                StyleConstants.setItalic(attr, false);
            }
        } else if (name.equals("\\ul")) {
            if (node.getLength() != 0) {
                StyleConstants.setUnderline(attr, true);
            }
        } else if (name.equals("\\ulnone")) {
            StyleConstants.setUnderline(attr, false);
        } else if (name.equals("\\strike")) {
            StyleConstants.setStrikeThrough(attr, true);
        } else if (name.equals("\\sub")) {
            StyleConstants.setSubscript(attr, true);
        } else if (name.equals("\\super")) {
            StyleConstants.setSuperscript(attr, true);
        } else if (!(name.equals("\\strike0") || name.equals("\\sub0") || name.equals("\\super0"))) {
            if (name.equals("\\f")) {
                String fontNum = Integer.toString(node.getLength());
                String fontName = (String)this.fontMap.get(fontNum);
                if (fontName != null) {
                    StyleConstants.setFontFamily(attr, fontName);
                }
            } else if (name.equals("\\fs")) {
                int fontSize = node.getLength();
                int realSize = fontSize / 2;
                StyleConstants.setFontSize(attr, realSize);
            } else if (name.equals("\\cf")) {
                int colorNumber = node.getLength();
                if (colorNumber < 0) {
                    colorNumber = 0;
                }
                Color fg = (Color)this.colorTable.get(colorNumber);
                StyleConstants.setForeground(attr, fg);
            } else if (name.equals("\\highlight")) {
                int colorNumber = node.getLength();
                Color bg = (Color)this.colorTable.get(colorNumber - 1);
                StyleConstants.setBackground(attr, bg);
            } else if (name.equals("\\li")) {
                int leftIndent = node.getLength();
                leftIndent = this.convertTwipsToPixels(leftIndent);
                StyleConstants.setLeftIndent(attr, leftIndent);
            } else if (name.equals("\\ri")) {
                int rightIndent = node.getLength();
                rightIndent = this.convertTwipsToPixels(rightIndent);
                StyleConstants.setRightIndent(attr, rightIndent);
            } else if (name.equals("\\fi")) {
                int firstIndent = node.getLength();
                firstIndent = this.convertTwipsToPixels(firstIndent);
                StyleConstants.setFirstLineIndent(attr, firstIndent);
            } else if (name.equals("\\sa")) {
                int spaceAbove = node.getLength();
                spaceAbove = this.convertTwipsToPixels(spaceAbove);
                StyleConstants.setSpaceAbove(attr, spaceAbove);
            } else if (name.equals("\\sb")) {
                int spaceBelow = node.getLength();
                spaceBelow = this.convertTwipsToPixels(spaceBelow);
                StyleConstants.setSpaceBelow(attr, spaceBelow);
            } else if (name.equals("\\sl")) {
                float lineSpacing = node.getLength();
                StyleConstants.setLineSpacing(attr, lineSpacing /= 240.0f);
            } else if (name.equals("\\s")) {
                int styleNumber = node.getLength();
                attr.addAttribute("styleNumber", new Integer(styleNumber));
            }
        }
    }

    private void processBodyGroup(RtfNode bodyGroup, MutableAttributeSet parentAttr, AdvancedRTFDocument document) throws BadLocationException, IOException {
        String groupName = this.getGroupName(bodyGroup);
        if (groupName.equals("\\datafield") || groupName.equals("\\fldinst") || groupName.equals("\\object") || groupName.equals("\\themedata") || groupName.equals("\\datastore") || groupName.equals("\\latentstyles") || groupName.equals("\\colorschememapping") || groupName.equals("\\objdata")) {
            return;
        }
        SimpleAttributeSet attr = new SimpleAttributeSet(parentAttr);
        int cnt = bodyGroup.getChildCount();
        String previousName = "";
        for (int i = 0; i < cnt; ++i) {
            RtfNode node = bodyGroup.getChild(i);
            String nodeName = node.getName();
            Object nodeContent = node.getContent();
            if (nodeName.equals("\\pard")) {
                attr = new SimpleAttributeSet(parentAttr);
            } else if (nodeName.equals("\\page")) {
                if (!document.getText(this.currentOffset - 1, 1).equals("\n")) {
                    document.insertString(this.currentOffset, "\n\f\n", attr);
                    this.currentOffset += 3;
                } else {
                    document.insertString(this.currentOffset, "\f", attr);
                    ++this.currentOffset;
                }
                nodeContent = null;
            } else if (nodeName.equals("\\cell")) {
                ++this.currentOffset;
            } else if (nodeName.equals("\\nestcell")) {
                ++this.currentOffset;
            } else if (nodeName.equals("*<group>*")) {
                if (!this.getGroupName(node).equals("\\nonesttables")) {
                    this.processBodyGroup(node, attr, document);
                }
            } else {
                if (nodeName.equals("\\pict")) {
                    this.processImage(bodyGroup, document);
                    return;
                }
                if (nodeName.equals("\\par")) {
                    document.insertString(this.currentOffset, "\n", attr);
                    this.removeCharacterAttributes(attr);
                    document.setParagraphAttributes(this.currentOffset, 0, attr, false);
                    ++this.currentOffset;
                    nodeContent = null;
                } else if (nodeName.substring(0, Math.min(2, nodeName.length())).equals("\\'")) {
                    if (node.getLength() != -1) {
                        String ll = nodeName.substring(2, 4);
                        byte b1 = Byte.parseByte(ll.substring(0, 1), 16);
                        byte b2 = Byte.parseByte(ll.substring(1, 2), 16);
                        byte value = (byte)(b1 * 16 + b2);
                        char ch = new Character((char)value).charValue();
                        byte[] bb = new byte[]{value};
                        String ss = new String(bb);
                        document.insertString(this.currentOffset, ss, attr);
                        ++this.currentOffset;
                        if (ll.length() > 2) {
                            ss = ll.substring(2);
                            document.insertString(this.currentOffset, ss, attr);
                            this.currentOffset += ss.length();
                        }
                    }
                } else {
                    if (nodeName.equals("\\bkmkstart")) {
                        return;
                    }
                    if (nodeName.equals("\\bkmkend")) {
                        return;
                    }
                    if (nodeName.equals("\\footnote")) {
                        return;
                    }
                    this.processAttribute(node, attr);
                }
            }
            if (nodeContent != null) {
                String content = (String)nodeContent;
                if (i != 0 && !previousName.equals("*<group>*") && content.charAt(0) == ' ') {
                    document.insertString(this.currentOffset, content.substring(1), attr);
                    this.currentOffset += content.length() - 1;
                } else {
                    document.insertString(this.currentOffset, content, attr);
                    this.currentOffset += content.length();
                }
            }
            previousName = nodeName;
        }
    }

    private void processGroup(RtfNode groupRoot, String groupName) throws BadLocationException, IOException {
        if (groupName.equals("\\fonttbl")) {
            this.processFontTable(groupRoot);
        } else if (groupName.equals("\\colortbl")) {
            this.processColorTable(groupRoot);
        } else if (groupName.equals("\\headerl")) {
            this.processEvenPageHeader(groupRoot);
        } else if (groupName.equals("\\headerf")) {
            this.processFirstPageHeader(groupRoot);
        } else if (groupName.equals("\\headerr")) {
            this.processOddPageHeader(groupRoot);
        } else if (groupName.equals("\\footerl")) {
            this.processEvenPageFooter(groupRoot);
        } else if (groupName.equals("\\footerr")) {
            this.processOddPageFooter(groupRoot);
        } else if (groupName.equals("\\footerf")) {
            this.processFirstPageFooter(groupRoot);
        } else if (groupName.equals("\\header")) {
            this.processCommonHeader(groupRoot);
        } else if (groupName.equals("\\footer")) {
            this.processCommonFooter(groupRoot);
        }
    }

    private void processFirstPageHeader(RtfNode headerRoot) throws BadLocationException, IOException {
        AdvancedRTFDocument firstPageHeaderDocument = new AdvancedRTFDocument();
        this.mainDocument.putProperty("first_page_header", firstPageHeaderDocument);
        this.currentOffset = 0;
        this.processDocumentBody(headerRoot, 0, firstPageHeaderDocument);
    }

    private void processEvenPageHeader(RtfNode headerRoot) throws BadLocationException, IOException {
        AdvancedRTFDocument evenPageHeaderDocument = new AdvancedRTFDocument();
        this.mainDocument.putProperty("even_page_header", evenPageHeaderDocument);
        this.currentOffset = 0;
        this.processDocumentBody(headerRoot, 0, evenPageHeaderDocument);
    }

    private void processOddPageHeader(RtfNode headerRoot) throws BadLocationException, IOException {
        AdvancedRTFDocument oddPageHeaderDocument = new AdvancedRTFDocument();
        this.mainDocument.putProperty("odd_page_header", oddPageHeaderDocument);
        this.currentOffset = 0;
        this.processDocumentBody(headerRoot, 0, oddPageHeaderDocument);
    }

    private void processFirstPageFooter(RtfNode headerRoot) throws BadLocationException, IOException {
        AdvancedRTFDocument firstPageFooterDocument = new AdvancedRTFDocument();
        this.mainDocument.putProperty("first_page_footer", firstPageFooterDocument);
        this.currentOffset = 0;
        this.processDocumentBody(headerRoot, 0, firstPageFooterDocument);
    }

    private void processEvenPageFooter(RtfNode headerRoot) throws BadLocationException, IOException {
        AdvancedRTFDocument evenPageFooterDocument = new AdvancedRTFDocument();
        this.mainDocument.putProperty("even_page_footer", evenPageFooterDocument);
        this.currentOffset = 0;
        this.processDocumentBody(headerRoot, 0, evenPageFooterDocument);
    }

    private void processOddPageFooter(RtfNode headerRoot) throws BadLocationException, IOException {
        AdvancedRTFDocument oddPageFooterDocument = new AdvancedRTFDocument();
        this.mainDocument.putProperty("odd_page_footer", oddPageFooterDocument);
        this.currentOffset = 0;
        this.processDocumentBody(headerRoot, 0, oddPageFooterDocument);
    }

    private void processCommonHeader(RtfNode headerRoot) throws BadLocationException, IOException {
        AdvancedRTFDocument commonHeaderDocument = new AdvancedRTFDocument();
        this.mainDocument.putProperty("common_header", commonHeaderDocument);
        this.currentOffset = 0;
        this.processDocumentBody(headerRoot, 0, commonHeaderDocument);
    }

    private void processCommonFooter(RtfNode headerRoot) throws BadLocationException, IOException {
        AdvancedRTFDocument commonFooterDocument = new AdvancedRTFDocument();
        this.mainDocument.putProperty("common_footer", commonFooterDocument);
        this.currentOffset = 0;
        this.processDocumentBody(headerRoot, 0, commonFooterDocument);
    }

    private void processFontTable(RtfNode fontTableRoot) {
        int cnt = fontTableRoot.getChildCount();
        String fontKey = "0";
        for (int i = 1; i < cnt; ++i) {
            RtfNode fontNode = fontTableRoot.getChild(i);
            String nodeName = fontNode.getName();
            String nodeContent = (String)fontNode.getContent();
            if (nodeName.equals("*<group>*")) {
                this.processFont(fontNode);
            } else if (nodeName.equals("\\f")) {
                fontKey = Integer.toString(fontNode.getLength());
            }
            if (nodeContent == null) continue;
            String fontName = nodeContent.substring(0, nodeContent.length() - 1).trim();
            this.fontMap.put(fontKey, fontName);
        }
    }

    private void processFont(RtfNode font) {
        String fontKey = Integer.toString(font.getChild(0).getLength());
        int lastIndex = font.getChildCount() - 1;
        RtfNode lastChild = font.getChild(lastIndex);
        while (lastIndex > 0 && lastChild.getContent() == null) {
            lastChild = font.getChild(--lastIndex);
        }
        if (lastChild.getContent() != null) {
            String fontName = (String)lastChild.getContent();
            fontName = fontName.substring(0, fontName.length() - 1).trim();
            this.fontMap.put(fontKey, fontName);
        }
    }

    private void processColorTableOld(RtfNode colorTableRoot) {
        int cnt = colorTableRoot.getChildCount();
        for (int i = 2; i < cnt; i += 4) {
            RtfNode redNode = colorTableRoot.getChild(i);
            RtfNode greenNode = colorTableRoot.getChild(i + 1);
            RtfNode blueNode = colorTableRoot.getChild(i + 2);
            int red = redNode.getLength();
            int green = greenNode.getLength();
            int blue = blueNode.getLength();
            Color color = new Color(red, green, blue);
            this.colorTable.add(color);
        }
    }

    private void processColorTable(RtfNode colorTableRoot) {
        int cnt = colorTableRoot.getChildCount();
        int i = 2;
        while (i + 2 < cnt) {
            int blue;
            int green;
            int red;
            RtfNode redNode = colorTableRoot.getChild(i);
            RtfNode greenNode = colorTableRoot.getChild(i + 1);
            RtfNode blueNode = colorTableRoot.getChild(i + 2);
            int n = red = redNode.getLength() < 0 ? 0 : redNode.getLength();
            if (red > 255) {
                red = 255;
            }
            int n2 = green = greenNode.getLength() < 0 ? 0 : greenNode.getLength();
            if (green > 255) {
                green = 255;
            }
            int n3 = blue = blueNode.getLength() < 0 ? 0 : blueNode.getLength();
            if (blue > 255) {
                blue = 255;
            }
            Color color = new Color(red, green, blue);
            this.colorTable.add(color);
            i += 4;
        }
    }

    private int processTableDefinition(RtfNode tableNode, MutableAttributeSet attr, int index, int level, AdvancedRTFDocument document) {
        int rowCount = 0;
        int colCount = 0;
        int cellCount = 0;
        boolean deep = false;
        Vector<MutableAttributeSet> rowsAttributes = new Vector<MutableAttributeSet>(100);
        int currentLevel = -1;
        int cnt = tableNode.getParent().getChildCount();
        for (int i = index + 1; i < cnt; ++i) {
            MutableAttributeSet rowAttr;
            RtfNode node = tableNode.getParent().getChild(i);
            String nodeName = node.getName();
            if (nodeName.equals("\\pard")) {
                int j;
                currentLevel = this.getParagraphLevel(node, tableNode.getParent(), i);
                if (currentLevel >= level) continue;
                SimpleAttributeSet tableAttr = new SimpleAttributeSet();
                BorderAttributes ba = new BorderAttributes();
                ba.setBorders(63);
                tableAttr.addAttribute("BorderAttributes", ba);
                rowAttr = (MutableAttributeSet)rowsAttributes.get(0);
                StyleConstants.setAlignment(tableAttr, StyleConstants.getAlignment(rowAttr));
                Vector cellAttributes = (Vector)rowAttr.getAttribute("cellAttributes");
                int[] widths = new int[cellAttributes.size()];
                for (j = 0; j < widths.length; ++j) {
                    MutableAttributeSet cellAttr = (MutableAttributeSet)cellAttributes.get(j);
                    Integer cw = (Integer)cellAttr.getAttribute("cellWidth");
                    widths[j] = cw != null ? cw : (this.getWidthFromPosition(cellAttributes, j) > 0 ? this.getWidthFromPosition(cellAttributes, j) : document.DOCUMENT_WIDTH / widths.length);
                }
                int[] heights = new int[rowCount];
                for (j = 0; j < rowCount; ++j) {
                    heights[j] = 1;
                }
                Element table = document.insertTable(this.currentOffset, rowCount, colCount, tableAttr, widths, heights);
                this.currentOffset = table.getStartOffset();
                for (int j2 = 0; j2 < rowCount; ++j2) {
                    rowAttr = (MutableAttributeSet)rowsAttributes.get(j2);
                    cellAttributes = (Vector)rowAttr.getAttribute("cellAttributes");
                    for (int k = 0; k < colCount; ++k) {
                        MutableAttributeSet cellAttr = (MutableAttributeSet)cellAttributes.get(k);
                        AdvancedRTFDocument.CellElement cell = (AdvancedRTFDocument.CellElement)table.getElement(j2).getElement(k);
                        BorderAttributes bas = (BorderAttributes)cellAttr.getAttribute("BorderAttributes");
                        ((BorderAttributes)cell.getAttribute("BorderAttributes")).setBorders(bas.getBorders());
                        ((BorderAttributes)cell.getAttribute((Object)"BorderAttributes")).lineColor = bas.lineColor;
                        Insets margins = (Insets)cellAttr.getAttribute("margins");
                        cell.setMargins(margins);
                    }
                }
                return i - 1;
            }
            if (!nodeName.equals("*<group>*")) continue;
            for (int j = 0; j < node.getChildCount(); ++j) {
                String groupName = node.getChild(j).getName();
                if (groupName.equals("\\trowd") && level == currentLevel) {
                    ++rowCount;
                    SimpleAttributeSet rowAttr2 = new SimpleAttributeSet();
                    this.processRowAttributes(node, rowAttr2, 1);
                    cellCount = (Integer)rowAttr2.getAttribute("cellCount");
                    if (colCount < cellCount) {
                        colCount = cellCount;
                    }
                    rowsAttributes.add(rowAttr2);
                    continue;
                }
                if (groupName.equals("\\nesttableprops") && level == currentLevel) {
                    RtfNode nestedNode = node.getChild(2);
                    ++rowCount;
                    SimpleAttributeSet rowAttr3 = new SimpleAttributeSet();
                    this.processRowAttributes(nestedNode, rowAttr3, 1);
                    cellCount = (Integer)rowAttr3.getAttribute("cellCount");
                    if (colCount < cellCount) {
                        colCount = cellCount;
                    }
                    rowsAttributes.add(rowAttr3);
                    continue;
                }
                if (!groupName.equals("*<group>*")) continue;
                for (int i1 = 0; i1 < node.getChildCount(); ++i1) {
                    RtfNode nn = node.getChild(i1);
                    if (!this.getGroupName(nn).equals("\\nesttableprops") || level != currentLevel) continue;
                    ++rowCount;
                    rowAttr = new SimpleAttributeSet();
                    this.processRowAttributes(nn, rowAttr, 1);
                    cellCount = (Integer)rowAttr.getAttribute("cellCount");
                    if (colCount < cellCount) {
                        colCount = cellCount;
                    }
                    rowsAttributes.add(rowAttr);
                    i1 = node.getChildCount();
                    j = node.getChildCount();
                }
            }
        }
        return index;
    }

    protected int getWidthFromPosition(Vector cellAttributes, int col) {
        if (col < cellAttributes.size() - 1) {
            MutableAttributeSet cellAttr = (MutableAttributeSet)cellAttributes.get(col);
            MutableAttributeSet nextCellAttr = (MutableAttributeSet)cellAttributes.get(col + 1);
            if (cellAttr.getAttribute("cellx") != null && nextCellAttr.getAttribute("cellx") != null) {
                int cellX = (Integer)cellAttr.getAttribute("cellx");
                int nextCellX = (Integer)nextCellAttr.getAttribute("cellx");
                int w = nextCellX - cellX;
            }
        }
        return -1;
    }

    private void processRowAttributes(RtfNode row, MutableAttributeSet attr, int index) {
        int cnt = row.getChildCount();
        Vector<SimpleAttributeSet> cellAttributes = new Vector<SimpleAttributeSet>(65);
        int cellCount = 0;
        for (int i = index; i < cnt; ++i) {
            SimpleAttributeSet cellAttr;
            RtfNode node = row.getChild(i);
            String nodeName = node.getName();
            if (nodeName.equals("\\tleft-")) {
                StyleConstants.setLeftIndent(attr, node.getLength());
                continue;
            }
            if (nodeName.equals("\\trqr")) {
                StyleConstants.setAlignment(attr, 2);
                continue;
            }
            if (nodeName.equals("\\trql")) {
                StyleConstants.setAlignment(attr, 0);
                continue;
            }
            if (nodeName.equals("\\trqc")) {
                StyleConstants.setAlignment(attr, 1);
                continue;
            }
            if (nodeName.equals("\\row")) {
                attr.addAttribute("cellAttributes", cellAttributes);
                attr.addAttribute("cellCount", new Integer(cellCount));
                return;
            }
            if (nodeName.equals("\\nestrow")) {
                attr.addAttribute("cellAttributes", cellAttributes);
                attr.addAttribute("cellCount", new Integer(cellCount));
                return;
            }
            if (nodeName.equals("\\clvertalt")) {
                ++cellCount;
                cellAttr = new SimpleAttributeSet();
                this.processCellAttributes(node, cellAttr, i);
                cellAttributes.add(cellAttr);
                continue;
            }
            if (!nodeName.equals("\\clvertalc")) continue;
            ++cellCount;
            cellAttr = new SimpleAttributeSet();
            this.processCellAttributes(node, cellAttr, i);
            cellAttributes.add(cellAttr);
        }
        attr.addAttribute("cellAttributes", cellAttributes);
        attr.addAttribute("cellCount", new Integer(cellCount));
    }

    private void processCellAttributes(RtfNode startCellNode, MutableAttributeSet attr, int index) {
        int cnt = startCellNode.getParent().getChildCount();
        BorderAttributes ba = new BorderAttributes();
        Insets margins = new Insets(2, 2, 2, 2);
        ba.setBorders(0);
        for (int i = index; i < cnt; ++i) {
            RtfNode node = startCellNode.getParent().getChild(i);
            String nodeName = node.getName();
            if (nodeName.equals("\\brdrcf")) {
                int colorInd = node.getLength();
                ba.lineColor = (Color)this.colorTable.get(colorInd);
                continue;
            }
            if (nodeName.equals("\\clbrdrt")) {
                ba.borderTop = 1;
                continue;
            }
            if (nodeName.equals("\\clbrdrl")) {
                ba.borderLeft = 1;
                continue;
            }
            if (nodeName.equals("\\clbrdrb")) {
                ba.borderBottom = 1;
                continue;
            }
            if (nodeName.equals("\\clbrdrr")) {
                ba.borderRight = 1;
                continue;
            }
            if (nodeName.equals("\\clpadl")) {
                margins.left = node.getLength() / 15;
                continue;
            }
            if (nodeName.equals("\\clpadr")) {
                margins.right = node.getLength() / 15;
                continue;
            }
            if (nodeName.equals("\\clpadt")) {
                margins.top = node.getLength() / 15;
                continue;
            }
            if (nodeName.equals("\\clpadb")) {
                margins.bottom = node.getLength() / 15;
                continue;
            }
            if (nodeName.equals("\\clwWidth")) {
                int width = node.getLength();
                width = this.convertTwipsToPixels(width);
                attr.addAttribute("cellWidth", new Integer(width));
                continue;
            }
            if (!nodeName.equals("\\cellx")) continue;
            attr.addAttribute("BorderAttributes", ba);
            attr.addAttribute("margins", margins);
            if (!attr.isDefined("cellWidth")) {
                int x = node.getLength();
                x = this.convertTwipsToPixels(x);
                attr.addAttribute("cellx", new Integer(x));
            }
            return;
        }
    }

    private void processTableContent(RtfNode tableNode, MutableAttributeSet attributes, int startIndex, int endIndex, int level, AdvancedRTFDocument document) throws BadLocationException, IOException {
        SimpleAttributeSet attr = new SimpleAttributeSet(attributes);
        String previousName = "";
        for (int i = startIndex; i < endIndex; ++i) {
            RtfNode node = tableNode.getParent().getChild(i);
            String nodeName = node.getName();
            Object nodeContent = node.getContent();
            if (nodeName.equals("\\pard")) {
                attr = new SimpleAttributeSet();
            } else if (nodeName.equals("\\tab")) {
                document.insertString(this.currentOffset, "\t", attr);
                ++this.currentOffset;
                nodeContent = null;
            } else if (nodeName.equals("\\page")) {
                if (!document.getText(this.currentOffset - 1, 1).equals("\n")) {
                    document.insertString(this.currentOffset, "\n\f\n", attr);
                    this.currentOffset += 3;
                } else {
                    document.insertString(this.currentOffset, "\f", attr);
                    ++this.currentOffset;
                }
                nodeContent = null;
            } else if (nodeName.equals("\\cell")) {
                ++this.currentOffset;
            } else if (nodeName.equals("\\nestcell")) {
                ++this.currentOffset;
            } else if (nodeName.equals("*<group>*")) {
                if (!this.getGroupName(node).equals("\\nonesttables")) {
                    this.processBodyGroup(node, attr, document);
                }
            } else if (nodeName.equals("\\par")) {
                document.insertString(this.currentOffset, "\n", attr);
                this.removeCharacterAttributes(attr);
                document.setParagraphAttributes(this.currentOffset, 0, attr, false);
                ++this.currentOffset;
                nodeContent = null;
            } else if (nodeName.equals("\\intbl")) {
                int innerLevel = this.getParagraphLevel(node, node.getParent(), i);
                if (innerLevel > level) {
                    int endOfTableInd = this.processTableDefinition(node, attr, i, level + 1, document);
                    this.processTableContent(node, attr, i, endOfTableInd, level + 1, document);
                    i = endOfTableInd + 1;
                }
            } else {
                this.processAttribute(node, attr);
            }
            if (nodeContent != null) {
                String content = (String)nodeContent;
                if (i != 0 && !previousName.equals("*<group>*") && content.charAt(0) == ' ') {
                    document.insertString(this.currentOffset, content.substring(1), attr);
                    this.currentOffset += content.length() - 1;
                } else {
                    document.insertString(this.currentOffset, content, attr);
                    this.currentOffset += content.length();
                }
            }
            previousName = nodeName;
        }
    }

    private int getParagraphLevel(RtfNode par, RtfNode parent, int index) {
        int result = 0;
        int cnt = parent.getChildCount();
        if (par.getName().equals("\\intbl")) {
            result = 1;
        }
        for (int i = index + 1; i < cnt; ++i) {
            RtfNode node = parent.getChild(i);
            String nodeName = node.getName();
            if (nodeName.equals("\\pard")) {
                return result;
            }
            if (nodeName.equals("\\intbl")) {
                result = 1;
                continue;
            }
            if (!nodeName.equals("\\itap")) continue;
            int level = node.getLength();
            if (level >= 0) {
                return level;
            }
            return result;
        }
        return result;
    }

    private String getGroupName(RtfNode groupNode) {
        if (groupNode.getChildCount() == 0) {
            return "";
        }
        RtfNode node = groupNode.getChild(0);
        if (node.getName().equals("\\*")) {
            node = groupNode.getChild(1);
        }
        return node.getName();
    }

    protected int convertTwipsToPixels(int value) {
        double result = value;
        return (int)(result /= 15.0);
    }

    protected void processImage(RtfNode pictureGroup, AdvancedRTFDocument document) throws IOException, BadLocationException {
        int cnt = pictureGroup.getChildCount();
        Object imageText = null;
        int imageType = -1;
        StringBuffer imageContent = null;
        String prevNodeName = "";
        for (int i = 0; i < cnt; ++i) {
            String content;
            RtfNode node = pictureGroup.getChild(i);
            if (node.getName().equals("\\pngblip")) {
                imageType = 0;
            }
            if ((content = (String)node.getContent()) != null) {
                if (imageContent == null) {
                    imageContent = prevNodeName.equals("*<group>*") ? new StringBuffer(content) : new StringBuffer(content.substring(0));
                } else {
                    imageContent.append(content);
                }
            }
            prevNodeName = node.getName();
        }
        if (imageContent.charAt(0) != ' ') {
            this.insertImage(imageContent.toString(), document);
        } else {
            this.insertImage(imageContent.toString().substring(1), document);
        }
    }

    protected void insertImage(String content, AdvancedRTFDocument document) throws IOException, BadLocationException {
        int len = content.length();
        byte[] buf = new byte[len / 2];
        for (int j = 0; j < len / 2; ++j) {
            byte b1 = this.get16(content.charAt(j * 2));
            byte b2 = this.get16(content.charAt(j * 2 + 1));
            buf[j] = (byte)(b1 * 16 + b2);
        }
        Image img = Toolkit.getDefaultToolkit().createImage(buf);
        ImageIcon icon = new ImageIcon();
        icon.setImage(img);
        if (icon.getIconHeight() < 0 || icon.getIconWidth() < 0) {
            return;
        }
        SimpleAttributeSet attr = new SimpleAttributeSet();
        StyleConstants.setIcon(attr, icon);
        document.insertString(this.currentOffset, " ", attr);
        ++this.currentOffset;
    }

    private byte get16(char c) {
        switch (c) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
            case 'a': {
                return 10;
            }
            case 'b': {
                return 11;
            }
            case 'c': {
                return 12;
            }
            case 'd': {
                return 13;
            }
            case 'e': {
                return 14;
            }
            case 'f': {
                return 15;
            }
        }
        return 0;
    }

    protected void removeCharacterAttributes(MutableAttributeSet attrs) {
        attrs.removeAttribute(StyleConstants.Background);
        attrs.removeAttribute(StyleConstants.Foreground);
        attrs.removeAttribute(StyleConstants.Bold);
        attrs.removeAttribute(StyleConstants.Italic);
        attrs.removeAttribute(StyleConstants.Subscript);
        attrs.removeAttribute(StyleConstants.Superscript);
        attrs.removeAttribute(StyleConstants.StrikeThrough);
        attrs.removeAttribute(StyleConstants.FontSize);
        attrs.removeAttribute(StyleConstants.FontFamily);
    }
}

