/*
 * Decompiled with CFR 0.152.
 */
package rtf.reader;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class RtfNode {
    public static final String TYPE = "type";
    public static final String NAME = "name";
    public static final String VAL = "content";
    public static final String LENGTH = "length";
    private Hashtable attrs = new Hashtable();
    private Vector childs = new Vector(100);
    private RtfNode parent = null;

    public RtfNode() {
    }

    public RtfNode(RtfNode parent) {
        parent.addChild(this);
    }

    public Enumeration getAttributeNames() {
        return this.attrs.keys();
    }

    public Object getAttribute(String key) {
        return this.attrs.get(key);
    }

    public String getType() {
        return (String)this.getAttribute(TYPE);
    }

    public String getName() {
        if (this.getAttribute(NAME) == null) {
            return "";
        }
        return (String)this.getAttribute(NAME);
    }

    public int getLength() {
        if (this.getAttribute(LENGTH) != null) {
            return (Integer)this.getAttribute(LENGTH);
        }
        return -1;
    }

    public Object getContent() {
        return this.getAttribute(VAL);
    }

    public void setAttribute(String key, Object obj) {
        this.attrs.put(key, obj);
    }

    public void setAttribute(String key, int obj) {
        this.setAttribute(key, new Integer(obj));
    }

    public void removeAttribute(String key) {
        this.attrs.remove(key);
    }

    public int getAttributeCount() {
        return this.attrs.size();
    }

    public Enumeration getChildList() {
        return this.childs.elements();
    }

    public int getChildCount() {
        return this.childs.size();
    }

    public RtfNode getChild(int idx) {
        return (RtfNode)this.childs.elementAt(idx);
    }

    public void addChild(RtfNode node) {
        this.childs.addElement(node);
        node.parent = this;
    }

    public void removeChild(int idx) {
        this.childs.removeElementAt(idx);
    }

    public int indexOf(RtfNode node) {
        return this.childs.indexOf(node);
    }

    public String toString() {
        String s = null;
        Enumeration keys = this.getAttributeNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            Object val = this.getAttribute(key);
            if (s == null) {
                s = " " + key + "='" + val + "'; ";
                continue;
            }
            s = s + key + "='" + val + "'";
        }
        return "[" + s + "]";
    }

    public void list() {
        this.list(0);
    }

    public void list(int tab) {
        for (int j = 0; j < tab; ++j) {
            System.out.print("\t");
        }
        System.out.println(this.toString());
        for (int i = 0; i < this.getChildCount(); ++i) {
            this.getChild(i).list(tab + 1);
        }
    }

    public RtfNode getParent() {
        return this.parent;
    }

    RtfNode cloneNode() {
        RtfNode clone = new RtfNode(this.parent);
        Enumeration keys = this.getAttributeNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            Object val = this.getAttribute(key);
            clone.setAttribute(key, val);
        }
        return clone;
    }
}

