/*
 * Decompiled with CFR 0.152.
 */
package rtf.reader;

import java.awt.Component;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import rtf.reader.RtfNode;

public class RtfParser {
    private final char[] digits = new char[]{'-', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    RtfNode root = new RtfNode();
    Reader in;
    int depth = 0;

    public RtfParser(Reader in) {
        this.in = in;
    }

    public RtfNode parse() throws IOException {
        this.parse(this.root);
        return this.root.getChild(0);
    }

    protected void parse(RtfNode parent) throws IOException {
        int i = this.in.read();
        StringBuffer str = new StringBuffer();
        while (i != -1) {
            char c = (char)i;
            if (c == '\\') {
                if (!str.toString().equals("\\")) {
                    this.createNode(parent, str.toString());
                    str.delete(0, str.length());
                } else {
                    this.createNode(parent, str.toString());
                    str.delete(0, str.length());
                    c = ' ';
                }
            }
            if (c == ';') {
                if (str.length() == 0) {
                    i = this.in.read();
                    continue;
                }
                if (str.charAt(0) == '\\') {
                    this.createNode(parent, str.toString());
                    str.delete(0, str.length());
                }
                str.append(c);
            } else if (c == ' ') {
                if (str.length() == 0) {
                    str.append(c);
                    i = this.in.read();
                    continue;
                }
                if (str.charAt(0) == '\\') {
                    this.createNode(parent, str.toString());
                    str.delete(0, str.length());
                }
                str.append(c);
            } else if (c == '\n' || c == '\r') {
                this.createNode(parent, str.toString());
                str.delete(0, str.length());
            } else if (c == '{') {
                if (str.length() == 1 && str.charAt(0) == '\\') {
                    str.setCharAt(0, ' ');
                    str.append(c);
                    i = this.in.read();
                    continue;
                }
                this.createNode(parent, str.toString());
                str.delete(0, str.length());
                RtfNode node = new RtfNode(parent);
                node.setAttribute("name", "*<group>*");
                ++this.depth;
                this.parse(node);
            } else {
                if (c == '}') {
                    if (str.length() == 1 && str.charAt(0) == '\\') {
                        str.setCharAt(0, ' ');
                        str.append(c);
                        i = this.in.read();
                        continue;
                    }
                    --this.depth;
                    this.createNode(parent, str.toString());
                    str.delete(0, str.length());
                    return;
                }
                str.append(c);
            }
            i = this.in.read();
        }
    }

    protected void createNode(RtfNode parent, String text) {
        if (text.length() == 0) {
            return;
        }
        RtfNode node = new RtfNode(parent);
        if (text.charAt(0) == '\\') {
            int index = this.lookupNumber(text);
            int length = this.cval(text);
            if (text.length() == 1) {
                node.setAttribute("name", "");
                node.setAttribute("content", text);
            } else if (text.charAt(1) == '\'') {
                String character = text.substring(2, 4);
                node.setAttribute("length", new Integer(2));
                node.setAttribute("name", text.substring(0, 4));
                if (text.length() > 4) {
                    node = new RtfNode(parent);
                    node.setAttribute("content", text.substring(4));
                }
            } else if (length != -1) {
                node.setAttribute("length", new Integer(length));
                node.setAttribute("name", text.substring(0, index));
            } else {
                node.setAttribute("name", text);
            }
        } else {
            node.setAttribute("name", "");
            node.setAttribute("content", text);
        }
    }

    private boolean isdigit(char c) {
        for (int j = 0; j < this.digits.length; ++j) {
            if (c != this.digits[j]) continue;
            return true;
        }
        return false;
    }

    private int lookupNumber(String s) {
        if (s.length() == 0) {
            return -1;
        }
        for (int j = s.length() - 1; j >= 0; --j) {
            if (this.isdigit(s.charAt(j))) continue;
            return j + 1;
        }
        return -1;
    }

    private int cval(String tok) {
        int idx = this.lookupNumber(tok);
        if (idx < 0 || tok.length() == idx) {
            return -1;
        }
        try {
            return Integer.parseInt(tok.substring(idx));
        }
        catch (Exception e) {
            return -1;
        }
    }

    public static void main(String[] args) throws IOException {
        JFrame frame = new JFrame("Test parser");
        frame.setDefaultCloseOperation(3);
        RtfParser parser = args.length > 0 ? new RtfParser(new FileReader(args[0])) : new RtfParser(new FileReader("C:/test.rtf"));
        parser.parse();
        DefaultMutableTreeNode treeRoot = new DefaultMutableTreeNode("ROOT");
        RtfParser.createTree(treeRoot, parser.root);
        JTree tree = new JTree(treeRoot);
        JScrollPane scroll = new JScrollPane(tree);
        frame.getContentPane().add(scroll);
        ((Component)frame).setSize(500, 700);
        frame.show();
    }

    private static void createTree(DefaultMutableTreeNode dest, RtfNode source) {
        for (int i = 0; i < source.getChildCount(); ++i) {
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(source.getChild(i));
            dest.add(node);
            RtfParser.createTree(node, source.getChild(i));
        }
    }
}

