/*
 * Decompiled with CFR 0.152.
 */
package rtf.view;

import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.SizeRequirements;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.BoxView;
import javax.swing.text.Element;
import javax.swing.text.FlowView;
import javax.swing.text.LabelView;
import javax.swing.text.ParagraphView;
import javax.swing.text.Position;
import javax.swing.text.StyleConstants;
import javax.swing.text.TabExpander;
import javax.swing.text.TabableView;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import rtf.AdvancedRTFDocument;

class AdvancedParagraphView
extends ParagraphView {
    public boolean isPageBreak = false;

    public AdvancedParagraphView(Element elem) {
        super(elem);
        this.strategy = new BajtextFlowStrategy();
    }

    protected View createRow() {
        float height;
        float addition;
        Element elem = this.getElement();
        BajtextRow row = new BajtextRow(elem);
        AttributeSet attr = this.getAttributes();
        float lineSpacing = StyleConstants.getLineSpacing(attr);
        if (lineSpacing > 1.0f && (addition = (height = row.getPreferredSpan(1)) * lineSpacing - height) > 0.0f) {
            row.setInsets(row.getTopInset(), row.getLeftInset(), (short)addition, row.getRightInset());
        }
        return row;
    }

    protected static int getSpaceCount(String content) {
        int result = 0;
        int index = content.indexOf(32);
        while (index >= 0) {
            ++result;
            index = content.indexOf(32, index + 1);
        }
        return result;
    }

    protected static int[] getSpaceIndexes(String content, int shift) {
        int cnt = AdvancedParagraphView.getSpaceCount(content);
        int[] result = new int[cnt];
        int counter = 0;
        int index = content.indexOf(32);
        while (index >= 0) {
            result[counter] = index + shift;
            ++counter;
            index = content.indexOf(32, index + 1);
        }
        return result;
    }

    public int getFlowSpan(int index) {
        int span = super.getFlowSpan(index);
        if (index == 0) {
            int firstLineIdent = (int)StyleConstants.getFirstLineIndent(this.getAttributes());
            span -= firstLineIdent;
        }
        return span;
    }

    protected void layoutMinorAxis(int targetSpan, int axis, int[] offsets, int[] spans) {
        super.layoutMinorAxis(targetSpan, axis, offsets, spans);
        int firstLineIdent = (int)StyleConstants.getFirstLineIndent(this.getAttributes());
        int leftIdent = (int)StyleConstants.getLeftIndent(this.getAttributes());
        int align = StyleConstants.getAlignment(this.getAttributes());
        if (align == 0 || align == 3) {
            offsets[0] = offsets[0] + firstLineIdent;
        }
        if (align == 3) {
            spans[0] = spans[0] - firstLineIdent;
        }
    }

    protected static boolean isSpace(View v) {
        int startOffset = v.getStartOffset();
        int len = v.getEndOffset() - startOffset;
        try {
            String text = v.getDocument().getText(startOffset, len);
            return text.equals(" ");
        }
        catch (Exception ex) {
            return false;
        }
    }

    class BajtextRow
    extends BoxView {
        private int rowNumber = 0;

        BajtextRow(Element elem) {
            super(elem, 0);
        }

        protected void loadChildren(ViewFactory f) {
        }

        public AttributeSet getAttributes() {
            View p = this.getParent();
            return p != null ? p.getAttributes() : null;
        }

        public float getAlignment(int axis) {
            if (axis == 0) {
                AttributeSet attr = this.getAttributes();
                int justification = StyleConstants.getAlignment(attr);
                switch (justification) {
                    case 0: 
                    case 3: {
                        return 0.0f;
                    }
                    case 2: {
                        return 1.0f;
                    }
                    case 1: {
                        return 0.5f;
                    }
                }
            }
            return super.getAlignment(axis);
        }

        public Shape modelToView(int pos, Shape a, Position.Bias b) throws BadLocationException {
            Rectangle r = a.getBounds();
            View v = this.getViewAtPosition(pos, r);
            if (v != null && !v.getElement().isLeaf()) {
                return super.modelToView(pos, a, b);
            }
            r = a.getBounds();
            int height = r.height;
            int y = r.y;
            Shape loc = super.modelToView(pos, a, b);
            r = loc.getBounds();
            r.height = height;
            r.y = y;
            return r;
        }

        public int getStartOffset() {
            int offs = Integer.MAX_VALUE;
            int n = this.getViewCount();
            for (int i = 0; i < n; ++i) {
                View v = this.getView(i);
                offs = Math.min(offs, v.getStartOffset());
            }
            return offs;
        }

        public int getEndOffset() {
            int offs = 0;
            int n = this.getViewCount();
            for (int i = 0; i < n; ++i) {
                View v = this.getView(i);
                offs = Math.max(offs, v.getEndOffset());
            }
            return offs;
        }

        protected void layoutMinorAxis(int targetSpan, int axis, int[] offsets, int[] spans) {
            this.baselineLayout(targetSpan, axis, offsets, spans);
        }

        protected SizeRequirements calculateMinorAxisRequirements(int axis, SizeRequirements r) {
            return this.baselineRequirements(axis, r);
        }

        protected int getViewIndexAtPosition(int pos) {
            if (pos < this.getStartOffset() || pos >= this.getEndOffset()) {
                return -1;
            }
            for (int counter = this.getViewCount() - 1; counter >= 0; --counter) {
                View v = this.getView(counter);
                if (pos < v.getStartOffset() || pos >= v.getEndOffset()) continue;
                return counter;
            }
            return -1;
        }

        public short getTopInset() {
            return super.getTopInset();
        }

        public short getLeftInset() {
            return super.getLeftInset();
        }

        public short getRightInset() {
            return super.getRightInset();
        }

        public void setInsets(short topInset, short leftInset, short bottomInset, short rightInset) {
            super.setInsets(topInset, leftInset, bottomInset, rightInset);
        }

        protected void layoutMajorAxis(int targetSpan, int axis, int[] offsets, int[] spans) {
            int i;
            View last;
            super.layoutMajorAxis(targetSpan, axis, offsets, spans);
            AttributeSet attr = this.getAttributes();
            if (StyleConstants.getAlignment(attr) == 2 && AdvancedParagraphView.isSpace(last = this.getView(this.getViewCount() - 1))) {
                int shift = spans[spans.length - 1];
                i = 0;
                while (i < offsets.length) {
                    int n = i++;
                    offsets[n] = offsets[n] + shift;
                }
                spans[spans.length - 1] = 1;
            }
            if (StyleConstants.getAlignment(attr) != 3 || axis != 0) {
                return;
            }
            if (this.getRowNumber() == this.getParent().getViewCount()) {
                return;
            }
            int cnt = offsets.length;
            int span = 0;
            for (i = 0; i < cnt; ++i) {
                span += spans[i];
            }
            if (this.getRowNumber() == 0) {
                return;
            }
            int startOffset = this.getStartOffset();
            int len = this.getEndOffset() - startOffset;
            String context = "";
            try {
                context = this.getElement().getDocument().getText(startOffset, len);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            int spaceCount = AdvancedParagraphView.getSpaceCount(context) - 1;
            if (spaceCount <= 0) {
                return;
            }
            int pixelsToAdd = targetSpan - span;
            int[] spaces = this.getSpaces(pixelsToAdd, spaceCount);
            int j = 0;
            int shift = 0;
            for (int i2 = 1; i2 < cnt; ++i2) {
                if (!(this.getView(i2) instanceof LabelView)) continue;
                LabelView v = (LabelView)this.getView(i2);
                int n = i2;
                offsets[n] = offsets[n] + shift;
                if (!AdvancedParagraphView.isSpace(v) || i2 == cnt - 1) continue;
                int add = 0;
                if (j < spaces.length) {
                    add = spaces[j];
                }
                int n2 = i2;
                spans[n2] = spans[n2] + add;
                shift += add;
                ++j;
            }
        }

        protected int[] getSpaces(int space, int cnt) {
            int[] result = new int[cnt];
            if (cnt == 0) {
                return result;
            }
            int base = space / cnt;
            int rst = space % cnt;
            for (int i = 0; i < cnt; ++i) {
                result[i] = base;
                if (rst <= 0) continue;
                int n = i;
                result[n] = result[n] + 1;
                --rst;
            }
            return result;
        }

        public float getMinimumSpan(int axis) {
            if (axis == 0) {
                AttributeSet attr = this.getAttributes();
                if (StyleConstants.getAlignment(attr) != 3) {
                    return super.getMinimumSpan(axis);
                }
                return this.getParent().getMinimumSpan(axis);
            }
            return super.getMinimumSpan(axis);
        }

        public float getMaximumSpan(int axis) {
            if (axis == 0) {
                AttributeSet attr = this.getAttributes();
                if (StyleConstants.getAlignment(attr) != 3) {
                    return super.getMaximumSpan(axis);
                }
                return this.getParent().getMaximumSpan(axis);
            }
            return super.getMaximumSpan(axis);
        }

        public float getPreferredSpan(int axis) {
            if (axis == 0) {
                AttributeSet attr = this.getAttributes();
                if (StyleConstants.getAlignment(attr) != 3) {
                    return super.getPreferredSpan(axis);
                }
                return this.getParent().getPreferredSpan(axis);
            }
            return super.getPreferredSpan(axis);
        }

        public void setRowNumber(int value) {
            this.rowNumber = value;
        }

        public int getRowNumber() {
            return this.rowNumber;
        }
    }

    public static class BajtextFlowStrategy
    extends FlowView.FlowStrategy {
        public void layout(FlowView fv) {
            super.layout(fv);
            AttributeSet attr = fv.getElement().getAttributes();
            float lineSpacing = StyleConstants.getLineSpacing(attr);
            boolean justifiedAlignment = StyleConstants.getAlignment(attr) == 3;
            boolean rightAlignment = StyleConstants.getAlignment(attr) == 2;
            int cnt = fv.getViewCount();
            for (int i = 0; i < cnt; ++i) {
                float height;
                float addition;
                BajtextRow row = (BajtextRow)fv.getView(i);
                if (lineSpacing > 1.0f && (addition = (height = row.getMinimumSpan(1)) * lineSpacing - height) > 0.0f) {
                    row.setInsets(row.getTopInset(), row.getLeftInset(), (short)addition, row.getRightInset());
                }
                if ((justifiedAlignment || rightAlignment) && !((AdvancedRTFDocument)fv.getElement().getDocument()).isSplitted) {
                    this.restructureRow(row, i + 1);
                }
                row.setRowNumber(i + 1);
            }
        }

        protected int layoutRow(FlowView fv, int rowIndex, int pos) {
            View v;
            AdvancedRTFDocument doc = (AdvancedRTFDocument)fv.getDocument();
            View row = fv.getView(rowIndex);
            row.removeAll();
            int x = fv.getFlowStart(rowIndex);
            int spanLeft = fv.getFlowSpan(rowIndex);
            int end = fv.getEndOffset();
            TabExpander te = fv instanceof TabExpander ? (TabExpander)((Object)fv) : null;
            int preX = x;
            int availableSpan = spanLeft;
            preX = x;
            int flowAxis = fv.getFlowAxis();
            boolean forcedBreak = false;
            while (pos < end && spanLeft > 0 && (v = this.createView(fv, pos, spanLeft, rowIndex)) != null) {
                if (doc.isSplitted) {
                    v = v.createFragment(v.getStartOffset(), v.getStartOffset() + 1);
                }
                int chunkSpan = flowAxis == 0 && v instanceof TabableView ? (int)((TabableView)((Object)v)).getTabbedSpan(x, te) : (int)v.getPreferredSpan(flowAxis);
                if (v.getBreakWeight(flowAxis, pos, spanLeft) >= 3000) {
                    int n = row.getViewCount();
                    if (n > 0) {
                        chunkSpan = (v = v.breakView(flowAxis, pos, x, spanLeft)) != null ? (flowAxis == 0 && v instanceof TabableView ? (int)((TabableView)((Object)v)).getTabbedSpan(x, te) : (int)v.getPreferredSpan(flowAxis)) : 0;
                    }
                    forcedBreak = true;
                }
                spanLeft -= chunkSpan;
                x += chunkSpan;
                if (v != null) {
                    row.append(v);
                    pos = v.getEndOffset();
                }
                if (!forcedBreak) continue;
                break;
            }
            if (spanLeft <= 0) {
                this.adjustRow(fv, rowIndex, availableSpan, preX);
            } else if (row.getViewCount() == 0) {
                v = this.createView(fv, pos, Integer.MAX_VALUE, rowIndex);
                row.append(v);
            }
            return row.getEndOffset();
        }

        protected void adjustRow(FlowView fv, int rowIndex, int desiredSpan, int x) {
            View v;
            int flowAxis = fv.getFlowAxis();
            View r = fv.getView(rowIndex);
            int n = r.getViewCount();
            int span = 0;
            int bestWeight = 0;
            int bestSpan = 0;
            int bestIndex = -1;
            boolean bestOffset = false;
            for (int i = 0; i < n; ++i) {
                int spanLeft;
                v = r.getView(i);
                int w = v.getBreakWeight(flowAxis, x + span, spanLeft = desiredSpan - span);
                if (w >= bestWeight && w > 0) {
                    bestWeight = w;
                    bestIndex = i;
                    bestSpan = span;
                    if (w >= 3000) break;
                }
                span = (int)((float)span + v.getPreferredSpan(flowAxis));
            }
            if (bestIndex < 0) {
                return;
            }
            int spanLeft = desiredSpan - bestSpan;
            v = r.getView(bestIndex);
            v = v.breakView(flowAxis, v.getStartOffset(), x + bestSpan, spanLeft);
            View[] va = new View[]{v};
            r.replace(bestIndex, n - bestIndex, va);
        }

        protected void restructureRow(View row, int rowNum) {
            int rowStartOffset = row.getStartOffset();
            int rowEndOffset = row.getEndOffset();
            String rowContent = "";
            try {
                rowContent = row.getDocument().getText(rowStartOffset, rowEndOffset - rowStartOffset);
                if (rowNum == 0) {
                    boolean index = false;
                    while (rowContent.charAt(0) == ' ' && (rowContent = rowContent.substring(1)).length() != 0) {
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            int rowSpaceCount = AdvancedParagraphView.getSpaceCount(rowContent);
            if (rowSpaceCount < 1) {
                return;
            }
            int[] rowSpaceIndexes = AdvancedParagraphView.getSpaceIndexes(rowContent, row.getStartOffset());
            int currentSpaceIndex = 0;
            for (int i = 0; i < row.getViewCount(); ++i) {
                View child = row.getView(i);
                if (child.getStartOffset() > rowSpaceIndexes[currentSpaceIndex] || child.getEndOffset() < rowSpaceIndexes[currentSpaceIndex]) continue;
                View first = null;
                if (child.getStartOffset() < rowSpaceIndexes[currentSpaceIndex]) {
                    first = child.createFragment(child.getStartOffset(), rowSpaceIndexes[currentSpaceIndex]);
                }
                View second = child.createFragment(rowSpaceIndexes[currentSpaceIndex], rowSpaceIndexes[currentSpaceIndex] + 1);
                View third = null;
                if (child.getEndOffset() > rowSpaceIndexes[currentSpaceIndex] + 1) {
                    third = child.createFragment(rowSpaceIndexes[currentSpaceIndex] + 1, child.getEndOffset());
                }
                int size = 3;
                if (first == null) {
                    --size;
                }
                if (third == null) {
                    --size;
                }
                View[] repl = new View[size];
                int ind = 0;
                if (first != null) {
                    repl[ind] = first;
                    ++ind;
                }
                repl[ind] = second;
                ++ind;
                if (third != null) {
                    repl[ind] = third;
                }
                row.replace(i, 1, repl);
                if (++currentSpaceIndex >= rowSpaceIndexes.length) break;
            }
            int childCnt = row.getViewCount();
        }
    }
}

