/*
 * Decompiled with CFR 0.152.
 */
package rtf.view;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.SizeRequirements;
import javax.swing.text.BoxView;
import javax.swing.text.Element;
import rtf.AdvancedRTFDocument;
import rtf.BorderAttributes;

public class CellView
extends BoxView {
    public CellView(Element elem) {
        super(elem, 1);
        AdvancedRTFDocument.CellElement cell = (AdvancedRTFDocument.CellElement)this.getElement();
        Insets margins = cell.getMargins();
        this.setInsets((short)margins.top, (short)margins.left, (short)margins.bottom, (short)margins.right);
    }

    public float getPreferredSpan(int axis) {
        float span = 0.0f;
        if (axis == 0) {
            AdvancedRTFDocument.CellElement cell = (AdvancedRTFDocument.CellElement)this.getElement();
            span = cell.getWidth();
        } else {
            AdvancedRTFDocument.CellElement cell = (AdvancedRTFDocument.CellElement)this.getElement();
            span = Math.max(super.getPreferredSpan(axis), (float)cell.getHeight());
        }
        return span;
    }

    public float getMinimumSpan(int axis) {
        float span = 0.0f;
        if (axis == 0) {
            AdvancedRTFDocument.CellElement cell = (AdvancedRTFDocument.CellElement)this.getElement();
            span = cell.getWidth();
        } else {
            AdvancedRTFDocument.CellElement cell = (AdvancedRTFDocument.CellElement)this.getElement();
            span = Math.max(super.getMinimumSpan(axis), (float)cell.getHeight());
        }
        return span;
    }

    public float getMaximumSpan(int axis) {
        float span = 0.0f;
        if (axis == 0) {
            AdvancedRTFDocument.CellElement cell = (AdvancedRTFDocument.CellElement)this.getElement();
            span = cell.getWidth();
        } else {
            AdvancedRTFDocument.CellElement cell = (AdvancedRTFDocument.CellElement)this.getElement();
            span = Math.max(super.getMaximumSpan(axis), (float)cell.getHeight());
        }
        return span;
    }

    protected SizeRequirements baselineRequirements(int axis, SizeRequirements r) {
        SizeRequirements sr = super.baselineRequirements(axis, r);
        if (axis == 1) {
            sr.alignment = 0.0f;
        }
        return sr;
    }

    protected SizeRequirements calculateMajorAxisRequirements(int axis, SizeRequirements r) {
        SizeRequirements sr = super.calculateMajorAxisRequirements(axis, r);
        if (axis == 1) {
            sr.alignment = 0.0f;
        }
        return sr;
    }

    protected SizeRequirements calculateMinorAxisRequirements(int axis, SizeRequirements r) {
        SizeRequirements sr = super.calculateMinorAxisRequirements(axis, r);
        if (axis == 1) {
            sr.alignment = 0.0f;
        }
        return sr;
    }

    protected void layout(int width, int height) {
        AdvancedRTFDocument.CellElement cell = (AdvancedRTFDocument.CellElement)this.getElement();
        Insets margins = cell.getMargins();
        this.setInsets((short)margins.top, (short)margins.left, (short)margins.bottom, (short)margins.right);
        super.layout(width, height);
    }

    public void paint(Graphics g, Shape a) {
        Rectangle alloc = a instanceof Rectangle ? (Rectangle)a : a.getBounds();
        super.paint(g, a);
        AdvancedRTFDocument.CellElement cell = (AdvancedRTFDocument.CellElement)this.getElement();
        BorderAttributes ba = (BorderAttributes)cell.getAttribute("BorderAttributes");
        Color oldColor = g.getColor();
        g.setColor(ba.lineColor);
        if (ba.borderLeft != 0) {
            g.drawLine(alloc.x, alloc.y, alloc.x, alloc.y + alloc.height);
        }
        if (ba.borderRight != 0) {
            g.drawLine(alloc.x + alloc.width, alloc.y, alloc.x + alloc.width, alloc.y + alloc.height);
        }
        if (ba.borderTop != 0) {
            g.drawLine(alloc.x, alloc.y, alloc.x + alloc.width, alloc.y);
        }
        if (ba.borderBottom != 0) {
            g.drawLine(alloc.x, alloc.y + alloc.height, alloc.x + alloc.width, alloc.y + alloc.height);
        }
        g.setColor(oldColor);
    }
}

