/*
 * Decompiled with CFR 0.152.
 */
package rtf.view;

import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.text.BoxView;
import javax.swing.text.Element;
import javax.swing.text.View;
import rtf.AdvancedRTFDocument;

public class RowView
extends BoxView {
    public RowView(Element elem, int axis) {
        super(elem, axis);
    }

    public RowView(Element elem) {
        super(elem, 0);
    }

    public void paint(Graphics g, Shape a) {
        Rectangle alloc = a instanceof Rectangle ? (Rectangle)a : a.getBounds();
        int n = this.getViewCount();
        AdvancedRTFDocument.RowElement row = (AdvancedRTFDocument.RowElement)this.getElement();
        int cellWidth = row.getWidth() / row.getChildCount();
        int shift = 0;
        for (int i = 0; i < n; ++i) {
            Rectangle tempRect = new Rectangle(alloc.x + shift, alloc.y, row.getCellWidth(i), alloc.height);
            this.paintChild(g, tempRect, i);
            shift += row.getCellWidth(i);
        }
    }

    public float getPreferredSpan(int axis) {
        float span = 0.0f;
        if (axis == 0) {
            AdvancedRTFDocument.RowElement row = (AdvancedRTFDocument.RowElement)this.getElement();
            span = row.getWidth();
        } else {
            span = 1.0f;
            for (int i = 0; i < this.getViewCount(); ++i) {
                span = Math.max(span, this.getView(i).getPreferredSpan(axis));
            }
        }
        return span;
    }

    public float getMinimumSpan(int axis) {
        float span = 0.0f;
        if (axis == 0) {
            AdvancedRTFDocument.RowElement row = (AdvancedRTFDocument.RowElement)this.getElement();
            span = row.getWidth();
        } else {
            span = 1.0f;
            for (int i = 0; i < this.getViewCount(); ++i) {
                span = Math.max(span, this.getView(i).getMinimumSpan(axis));
            }
        }
        return span;
    }

    public float getMaximumSpan(int axis) {
        float span = 0.0f;
        if (axis == 0) {
            AdvancedRTFDocument.RowElement row = (AdvancedRTFDocument.RowElement)this.getElement();
            span = row.getWidth();
        } else {
            span = 1.0f;
            for (int i = 0; i < this.getViewCount(); ++i) {
                span = Math.max(span, this.getView(i).getMaximumSpan(axis));
            }
        }
        return span;
    }

    protected void paintChild(Graphics g, Rectangle alloc, int index) {
        View child = this.getView(index);
        child.paint(g, alloc);
    }
}

