/*  File bex.c  */

#ifdef __MSDOS__
#include <dir.h>
#include <io.h>
#else
#include <unistd.h>
#endif
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define BUFSIZE 10000

char
    *select,
    *programname,
    buf1 [BUFSIZE + 1],
    buf2 [256];

void
    get_programname (char const *argv0),
    errit (char const *format, ...),
    syntax (void);

void main (int argc, char *argv [])
{
    int
        use_label,
        use_cols,
        a,
        i,
        j,
        k,
        n;
    char
        *label;

    get_programname (argv [0]);

    if (argc < 2 || isatty (fileno (stdin)))
	syntax ();

    use_label = use_cols = 0;

    if (argv [1][0] < '0' || argv [1][0] > '9') {
            use_label = 1;
            label = argv [1];
            argv++;
            argc--;
    }

    n = 0;
    for (i = 1; i < argc; i++) {
        j = atoi (argv [i]);
        if (j < 1)
            errit ("Invalid column number %i", j);
        if (j > n)
            n = j;
    }
    if (n) {
        use_cols = 1;
        select = (char *) malloc (n * sizeof (char));
        for (i = 0; i < n; i++)
            select [i] = 0;

        for (i = 1; i < argc; i++)
            select [atoi (argv [i]) - 1] = 1;
    }

    while (fgets (buf1, BUFSIZE, stdin)) {
        if (use_label) {
            i = sscanf (buf1, "%s", buf2);
            if (i != 1 || strcmp (buf2, label))
                continue;
        }
        if (use_cols) {
            j = 0;
            for (i = 0; i < n; i++) {
                a = sscanf (buf1 + j, "%s%n", buf2, &k);
                if (select [i] && a == 1)
                    printf (" %s", buf2);
                j += k;
            }
            printf ("\n");
        } else
            fputs (buf1, stdout);
    }
}

void errit (char const *format, ...)
{
    va_list
	list;

    fprintf (stderr, "\nError %s: ", programname);

    va_start (list, format);
    vfprintf (stderr, format, list);

    fprintf (stderr, "\n\n");

    exit (1);
}

void get_programname (char const *argv0)
{
#ifdef __MSDOS__
    char
        name [MAXFILE];
    fnsplit (argv0, NULL, NULL, name, NULL);
    programname = strdup (name);
#else   /* unix */
    char
        *p;
    p = strrchr (argv0, '/');
    if (p)
        programname = strdup (p + 1);
    else
        programname = strdup (argv0);
#endif    
}

void syntax ()
{
    fprintf (
        stderr,
        "\n(c) P. Kleiweg 1996\n"
        "\nSyntax: %s [label] [columnnumber...] < infile > outfile \n\n",
        programname
    );
    exit (1);
}
