/*  File net.c  */

#ifdef __MSDOS__
#include <dir.h>
#endif
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX 256

char
    *programname,
    prefix [256];
int
    un [MAX + 1],
    add [MAX + 1];

void
    get_programname (char const *argv0),
    errit (char const *format, ...),
    syntax (void);

void main (int argc, char *argv [])
{
    int
        i,
        j,
        from,
        to,
        full = 0,
        layers;

    get_programname (argv [0]);

    while (argc > 1) {
        if (! strcmp (argv [1], "-f")) {
            full = 1;
            argc--;
            argv++;
        } else if (argv [1][0] == '-')
            syntax ();
        else
            break;
    }

    if (argc < 3)
        syntax ();

    if (argc > MAX)
        errit ("Far Out!");

    layers = argc - 1;
    add [0] = un [0] = 0;
    for (i = 1; i <= layers; i++) {
        un [i] = atoi (argv [i]);
        if (un [i] < 1)
            errit ("Illegal number of units in layer %i", i);
        add [i] = add [i - 1] + un [i - 1];
    }

    printf ("# ");
    for (i = 1; i <= layers; i++)
        printf ("%i.", un [i]);
    printf ("net\n");
    if (full)
        printf ("# fully connected\n");

    printf (
        "\n# n_units n_in n_out\n%i %i %i\n",
        un [layers] + add [layers],
        un [1],
        un [layers]
    );

    for (to = 2; to <= layers; to++) {
        printf ("\n# bias -> layer %i\n", to);
        strcpy (prefix, "0 ->");
        for (i = 1; i <= un [to]; i++) {
            if ((i % 16) == 1)
                printf (prefix);
            printf (" %i", add [to] + i);
            if ((i % 16) == 0)
                printf ("\n");
        }
        if ((i % 16) != 1)
            printf ("\n");
    }

    for (to = 2; to <= layers; to++) {
        for (from = (full ? 1 : to - 1); from < to; from++) {
            printf ("\n# layer %i -> layer %i\n", from, to);
            for (i = add [from] + 1; i <= add [from] + un [from]; i++) {
                sprintf (prefix, "%i ->", i);
                for (j = 1; j <= un [to]; j++) {
                    if ((j % 16) == 1)
                        printf (prefix);
                    printf (" %i", add [to] + j);
                    if ((j % 16) == 0)
                        printf ("\n");
                }
                if ((j % 16) != 1)
                    printf ("\n");
            }
        }
    }
}

void errit (char const *format, ...)
{
    va_list
	list;

    fprintf (stderr, "\nError %s: ", programname);

    va_start (list, format);
    vfprintf (stderr, format, list);

    fprintf (stderr, "\n\n");

    exit (1);
}

void get_programname (char const *argv0)
{
#ifdef __MSDOS__
    char
        name [MAXFILE];
    fnsplit (argv0, NULL, NULL, name, NULL);
    programname = strdup (name);
#else   /* unix */
    char
        *p;
    p = strrchr (argv0, '/');
    if (p)
        programname = strdup (p + 1);
    else
        programname = strdup (argv0);
#endif    
}

void syntax ()
{
    fprintf (
        stderr,
        "\nNetwork Generator\n"
        "\n(c) P. Kleiweg 1996\n"
        "\nSyntax: %s [-f] in [hidden ...] out\n"
        "\n  -f : fully connected\n"
        "\nin     : number of units in input layer"
        "\nhidden : number of units in hidden layer"
        "\nout    : number of units in output layer\n"
        "\nNone or more than one hidden layer can be specified\n\n",
        programname
    );
    exit (1);
}
