set title "Neural Net Demonstratie: De XOR functie"
set xlabel "Number of epochs"
set ylabel "Output value"
set grid
set yrange [0:1.2]
plot "demo_plt.p00" title "0 0" with lines, \
     "demo_plt.p01" title "0 1" with lines, \
     "demo_plt.p10" title "1 0" with lines, \
     "demo_plt.p11" title "1 1" with lines
pause -1 "Toets ENTER voor vervolg"

set ylabel "Error: Euclidean Distance"
plot "demo_plt.e00" title "0 0" with lines, \
     "demo_plt.e01" title "0 1" with lines, \
     "demo_plt.e10" title "1 0" with lines, \
     "demo_plt.e11" title "1 1" with lines
pause -1 "Toets ENTER voor vervolg"

plot "demo_plt.em" title "Mean error" with lines, \
     "demo_plt.ew" title "Maximal error" with lines
pause -1 "Toets ENTER voor vervolg"

set nokey
set nogrid
set xrange [0:1]
set yrange [0:1]
set zrange [0:1]
set xlabel "Input unit 1"
set ylabel "Input unit 2"
set zlabel "Output"
set samples 21
set isosamples 11
set hidden3d
set xtics 0,1,1
set ytics 0,1,1
set ztics 0,0.2,1
load "demo_out.fun"
splot unit5(x, y)
pause -1 "Toets ENTER voor vervolg"

set key
set zlabel "Hidden units"
set nohidden3d
splot unit3(x, y) title "Hidden unit 1", \
      unit4(x, y) title "Hidden unit 2"
pause -1 "Toets ENTER voor vervolg"
