/*  file:  parity.c  */

#ifdef __MSDOS__
#include <dir.h>
#endif
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

char
    *programname;

void
    syntax (void),
    errit (char const *format, ...),
    get_programname (char const *argv0);

int main (int argc, char *argv [])
{
    int
        i, j, p, n, max;

    get_programname (argv [0]);

    if (argc != 2)
	syntax ();

    n = atoi (argv [1]);
    if (n < 1)
        errit ("Invalid value: %s", argv [1]);

    max = (1 << n);

    printf ("# Parity problem\n# n_in  = %i\n# n_out = 1\n\n", n);

    for (i = 0; i < max; i++) {
        p = 0;
        printf ("p");
        for (j = n - 1; j >= 0; j--)
            printf ((i & (1 << j)) ? "1" : "0");
        for (j = n - 1; j >= 0; j--) {
            if (i & (1 << j)) {
                printf (" 1");
                p = 1 - p;
            } else
                printf (" 0");
        }
        printf ("  %i\n", p);
    }

    return 0;
}

void errit (char const *format, ...)
{
    va_list
	list;

    fprintf (stderr, "\nError %s: ", programname);

    va_start (list, format);
    vfprintf (stderr, format, list);

    fprintf (stderr, "\n\n");

    exit (1);
}

void get_programname (char const *argv0)
{
#ifdef __MSDOS__
    char
        name [MAXFILE];
    fnsplit (argv0, NULL, NULL, name, NULL);
    programname = strdup (name);
#else   /* unix */
    char
        *p;
    p = strrchr (argv0, '/');
    if (p)
        programname = strdup (p + 1);
    else
        programname = strdup (argv0);
#endif    
}

void syntax ()
{
    fprintf (
	stderr,
        "\nParity pattern generator\n"
        "\n(c) P. Kleiweg 1996\n"
        "\nSyntax: %s N\n"
        "\nN is a positive integer\n",
	programname
    );
    exit (1);
}
